/* videofnc.c   compiler graphics library dependent functions */
/* `MIDI Sequencing In C', Jim Conger, M&T Books, 1989 */

/* #define TURBOC 1   Define if using Turbo C, leave out for Microsoft */

#include <stdio.h>
#include <conio.h>

#ifdef TURBOC
   #include <graphics.h>
#else
   #include <graph.h>
#endif

#include "standard.h"
#include "screenf.h"
#include "video.h"


/* write string to x,y on screen.  Colors determined by attrib. */
/*      slow version using library functions */
void
writeword( char *string, int x, int y, int attrib )
{
#ifdef TURBOC
   textattr(attrib);
   gotoxy(x, y);
   cputs(string);
#else
   _setbkcolor(( long )( attrib & 0xF0 ) >> 4 );
   _settextcolor( attrib & 0x0F );
   _settextposition(y, x);
   _outtext(string);
#endif
}

void
clearscreen( int attrib )       /* clears screen and homes cursor */
{
#ifdef TURBOC
   textattr(attrib);
   clrscr();
#else
   _setbkcolor(( long )( attrib & 0xF0 ) >> 4 );
   _settextcolor( attrib & 0x0F );
   _clearscreen(_GCLEARSCREEN);
   _settextposition(1, 1);
#endif
}

void
clearline( int lineno, int attrib )         /* blank out a line */
{
   static char buf[] =
"                                                                           ";

#ifdef TURBOC
   textattr(attrib);
   gotoxy(1, lineno);
   cputs(buf);
#else
   _setbkcolor(( long )( attrib & 0xF0 ) >> 4 );
   _settextcolor( attrib & 0x0F );
   _settextposition(lineno, 0);
   _outtext(buf);
#endif
}

void
csrplot( int x, int y )         /* moves cursor to x,y on screen */
{
#ifdef TURBOC
   gotoxy(x,y);
#else
   _settextposition(x,y);
#endif
}

void
setvideomode( int mode )        /* sets the video mode for screen output */
{
#ifdef TURBOC
   int gdriver, gmode, gerror;

   if (mode <= 3  ||  mode == 7) {
      closegraph();
      textmode(mode);
      directvideo = 1;          /* use direct video RAM output */
   }
   else {       /* use Turbo C's ability to find highest res. graph mode */
      detectgraph( &gdriver, &gmode );
      if (gdriver < 0) {
         writerr("Did not detect graphics hardware.", g_text_char_v,
                                       g_norm_attrib, g_emph_attrib );
         return;
      }
      switch (gdriver) {        /* translate BIOS mode #'s to Turbo C codes */
      case EGA:
      case EGA64:
         if (mode == 15)
            gmode = 1;
         else
            gmode = 0;
         break;
      case EGAMONO:
         gmode = 3;
         break;
      case HERCMONO:
         gmode = 0;
         break;
      case VGA:
         if (mode == 14)
            gmode = 0;
         else if (mode == 18)
            gmode = 2;
         else
            gmode = 1;
         break;
      case GCA:
      case MCGA:
         gmode = 4;
         break;
      default:
         gmode = 0;
      }             /* endswitch */
      initgraph( &gdriver, &gmode, "");
      gerror = graphresult();
      if (gerror < 0) {
         writerr("Could not enter default graphics mode.", g_text_char_v,
                                            g_norm_attrib, g_emph_attrib );
         return;
      }
      directvideo = 0;  /* use BIOS calls during graphics output */
   }
#else
   _setvideomode(mode);
#endif
}

void
dotplot( int x, int y, int color )  /* sets one pixel color on screen at x,y */
{
#ifdef TURBOC
   putpixel( x, y, color );
#else
   _setcolor(color);
   _setpixel(x, y);
#endif
}

/* draws a rectangle on screen from top left x1,y1 to bottom right x2,y2 */
/*      if fill != 0, rectangle area is filled in; else just border drawn */
void
draw_rectangle( int fill, int x1, int y1, int x2, int y2, int color )
{
#ifdef TURBOC
   if (fill) {
      setfillstyle( SOLID_LINE, color );
      bar( x1, y1, x2, y2 );
   }
   else {
      setcolor(color);
      setlinestyle( SOLID_LINE, 0xFFFF, NORM_WIDTH );
      rectangle( x1, y1, x2, y2 );
   }
#else
   _setcolor(color);
   if (fill) {
      _rectangle(_GFILLINTERIOR, x1, y1, x2, y2 );
   }
   else {
      _rectangle(_GBORDER, x1, y1, x2, y2 );
   }
#endif
}

/* draws a line between x1,y1 and x2,y2 with given color */
void
drawline( int x1, int y1, int x2, int y2, int color )
{
#ifdef TURBOC
   setcolor(color);
   moveto(x1, y1);
   lineto(x2, y2);
#else
   _setcolor(color);
   _moveto(x1, y1);
   _lineto(x2, y2);
#endif
}

/* underline a string at character location x,y (not pixel x,y) */
/*      mode is video mode - used to determine character heights in pixels */
void
wordul( int mode, char *string, int x, int y, int color )
{
   int chary, charx, ypos, xpos, xorcolor, nchar, dotnow;

   switch (mode) {
   case 7:
      chary = 16;
      charx = 9;
      break;
   case 15:
   case 16:
      chary = 14;
      charx = 8;
      break;
   case 17:
   case 18:
      chary = 16;
      charx = 8;
      break;
   default:
      chary = charx = 8;
   }        /* endswitch */
   ypos = y*chary - 1;
   xpos = (x-1) * charx;

#ifdef TURBOC
   dotnow = getpixel( xpos, ypos );
#else
   dotnow =_getpixel( xpos, ypos );
#endif
   xorcolor = dotnow ^ color;
   nchar = 0;
   while (*string++)
      nchar++;

   drawline( xpos, ypos, xpos + nchar*charx, ypos, xorcolor );
}

/* draw sprite on screen at  xpos, ypos */
void
draw_sprite( struct sprite spr, int xpos, int ypos, int line_color,
                                                    int back_color )
{
   int i, j, k, x, y;
   unsigned int drawbyte, dotput;
   char *sp;

   y = ypos;
   sp = spr.sdata;

   for (i = 0; i < spr.stall; i++) {
      x = xpos;
      for (j = 0; j < spr.swide; j++) {
         drawbyte = *sp++;
         for (k = 0; k < 8; k++) {
            dotput = drawbyte & 0x80;
            if (dotput)
#ifdef TURBOC
               putpixel( x++, y, line_color );
            else
               putpixel( x++, y, back_color );
#else
               _setcolor( line_color );
            else
               _setcolor( back_color );
            _setpixel( x++, y );
#endif
            drawbyte <<= 1;
         }
      }
      y++;
   }
}

/* XOR sprite on screen at  xpos, ypos */
/*      color is color sprite is to have over a black background */
void
xsprite( struct sprite spr, int xpos, int ypos, int color )
{
   int i, j, k, x, y;
   unsigned int drawbyte, dotnow;
   char *sp;

   y = ypos;
   sp = spr.sdata;

   for (i = 0; i < spr.stall; i++) {
      x = xpos;
      for (j = 0; j < spr.swide; j++) {
         drawbyte = *sp++;
         for (k = 0; k < 8; k++) {
            if (drawbyte & 0x80) {
#ifdef TURBOC
               dotnow = getpixel(x,y);
               putpixel( x, y, dotnow ^ color );   /* XOR color */
#else
               dotnow = _getpixel(x,y);
               _setcolor( dotnow ^ color );
               _setpixel(x, y);
#endif
            }
            x++;
            drawbyte <<= 1;
         }
      }
      y++;
   }
}
