/* video.h  header file for video attribute and mode data */
/* works in conjunction with install.c's output file install.dat */

/* defines to allow same header file to work for both initialization */
/* and reference.  Only define the word ALLOCATE in the main() module. */

#ifdef	ALLOCATE
    #define GLOBAL
    #define INIT(x) =x
#else
    #define GLOBAL  extern
    #define INIT(x)
#endif

GLOBAL int g_text_mode;
GLOBAL int g_graph_mode;
GLOBAL int g_dots_v;		/* graphics pixels vertically */
GLOBAL int g_dots_h;		/*		 horizontally */
GLOBAL int g_norm_attrib;	/* attribute for normal characters */
GLOBAL int g_cursor_attrib;	/*	     for the cursor highlight */
GLOBAL int g_emph_attrib;	/*	     for emphasized characters */
GLOBAL int g_let_dots_v;	/* character pixels vertical */
GLOBAL int g_let_dots_h;	/* character pixels width */
GLOBAL int g_text_char_v;	/* number of char lines, text mode */
GLOBAL int g_text_char_h;	/* number of char columns */
GLOBAL int g_graph_char_h;	/* ditto in graphics mode for char */
GLOBAL int g_graph_char_v;	/*   written to graphics screens */
GLOBAL int g_text_colors;	/* total number of colors available */
GLOBAL int g_graph_colors;

GLOBAL int g_line_color;	/* the color lines are drawn with */
GLOBAL int g_back_color;	/* the background color */
GLOBAL int g_emph_color;	/* line color for emphasis */
