/* screenf.h  header file for screenf.lib */
/* for writscrn.c, videofnc.c, inputf.c, chain.c */

#define WHITE	    1
#define BLACK	    0
				/* starting memory for video page */
#define CVIDMEM     0xB8000000L /* CGA text/graphics */
#define HVIDMEM     0xB0000000L /* monochrome/hercules text */
#define EVIDMEM     0xA8000000L /* EGA/VGA */

#define SCRNWIDE 80	    /* usual width and heigth of screen in chars */
#define SCRNTALL 25
			    /* codes for screen char attributes */

#define BWC	0x07	/* black and white */
#define ULC	0x01	/* underlined */
#define RVC	0x70	/* reverse video */
#define BRVC	0xF0	/* blinking reverse video */
#define BRBWC	0x0F	/* bright black and white */

	/* structures used in modules */

/* writscrn.c */

struct	selement   {	/* used by movescrn() for cursor element definition */
    int   xpos;
    int   ypos;
    char  content[15];
    int   nup;
    int   ndown;
    int   nleft;
    int   nright;
    int   key;
};

/* videofnc.c */

struct	sprite	{	/* sprite structure; sdata is bit map */
    int   swide;
    int   stall;
    unsigned char *sdata;
};

/* chain.c */

struct strchain   {	/* used for linked list storage of screen displays */
    char  *line;
    struct strchain *next;
};

/* old style function declarations:

struct strchain *inpchain(),
		*chain(),
		*chainalloc();
char *strsave();		*/

	/* function prototypes */

/* videofnc.c */

void writeword( char *string, int x, int y, int attrib );
void clearscreen( int attrib );
void clearline( int lineno, int attrib );
void csrplot( int x, int y );
void setvideomode( int mode );
void dotplot( int x, int y, int color );
void draw_rectangle( int fill, int x1, int y1, int x2, int y2, int color );
void drawline( int x1, int y1, int x2, int y2, int color );
void wordul( int mode, char *string, int x, int y, int color );
void draw_sprite( struct sprite spr, int xpos, int ypos, int line_color,
							 int back_color );
void xsprite( struct sprite spr, int xpos, int ypos, int color );

/* writscrn.c */

int movescrn( int vidmode, struct selement scrnarray[],
				int first, int last, int normal, int hilit );
void to_new_csr( int vidmode, struct selement scrnarray[],
				int k, int oldk, int normal, int hilit );
void writerr( char *s, int lineno, int normal, int hilit );
void clearwind( int tx, int ty, int bx, int by, int attrib );
void initscrn( struct selement scrnarray[], int first, int last, int attrib );
void finitscrn( struct selement scrnarray[], int first, int last, int attrib,
								   int mode );
void fwriteword( char *string, int x, int y, int attrib, int mode );
void write_int( int value, int x, int y, int attrib );

/* chain.c */

struct strchain *inpchain( char *file, int maxlen );
struct strchain *chain( struct strchain *p, char *w );
void dechain( struct strchain *p );
void dispchain( struct strchain *p, int y, int attrib );
struct strchain *chainalloc( void );
char *strsave( char *s );
void fdispchain( struct strchain *p, int y, int attrib, int mode );

/* inputf.c */

int getfloat( int lineno, char *prompt, float *value, float min, float max,
	      int normal, int hilit );
int getint(   int lineno, char *prompt,   int *value,	int min,   int max,
	      int normal, int hilit );
int getstr(   int lineno, char *prompt, char *string, int max, int attrib );
int get_string( char *str, int max );
