/* mtut2.c  save and load functions */
/* `MIDI Sequencing In C', Jim Conger, M&T Books, 1989 */

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#ifndef TURBOC
   #include <direct.h>
   #include <malloc.h>
#endif

#include "screenf.h"
#include "standard.h"
#include "mpu401.h"
#include "mt.h"
#include "video.h"
#include "filefunc.h"
#include "mtdeclar.h"


/* Runs the import menu for loading one track off of a disk file */
void
import_menu( void )
{
   int source_track, dest_track, i, pick, temp_metrate, temp_meter,
                                        temp_pitchbend, temp_exclusive, ans;
   char tempfile[14], buf[SCRNWIDE], nbuf[10], *s, temp_songtitle[TITLE_WIDE];
   FILE *stream;
   struct trackdata temp_trackarray[NTRACK];

   while (1) {
      pick = pick_file( g_songdir, "*.sng",
         "Select a file to use for loading track data.  ESC to quit.");
      if (pick < 0)
         return;

      strcpy( tempfile, g_file_disp[pick].content );
      chdir( g_songdir );               /* change directory to song area */
      stream = fopen( tempfile, "rb");
      if (stream == NULL) {
         strcpy( buf, "Could not open song file ");
         strcat( buf, g_songdir );
         s = strchr( g_songdir, '\0');
         if (*--s != '\\')
            strcat( buf, "\\");
         strcat( buf, tempfile );
         writerr( buf, g_text_char_v, g_norm_attrib, g_norm_attrib );
         chdir( g_prodir );
         return;
      }
      else break;
   }

   /* Read import file header, but not track data (yet) */

   get_from_file(  temp_songtitle, TITLE_WIDE,  stream );
   get_from_file( &temp_metrate,   sizeof(int), stream );
   get_from_file( &temp_meter,     sizeof(int), stream );
   get_from_file( &temp_pitchbend, sizeof(int), stream );
   get_from_file( &temp_exclusive, sizeof(int), stream );
   for (i = 0; i < NTRACK; i++) {
      get_from_file(  temp_trackarray[i].name,  TRACK_NAME_WIDE,  stream );
      get_from_file( &temp_trackarray[i].midichan,  sizeof(int),  stream );
      get_from_file( &temp_trackarray[i].numevents, sizeof(long), stream );
      get_from_file( &temp_trackarray[i].active,    sizeof(int),  stream );
      get_from_file( &temp_trackarray[i].midivol,   sizeof(int),  stream );
   }

   /* clear screen and put import menu up */
   clearscreen( g_norm_attrib );
   fdispchain( g_chain[5], 1, g_norm_attrib, g_text_mode );

   /* put each track's name, channel and number of events on screen */

   fwriteword( temp_songtitle, 26, 5, g_emph_attrib, g_text_mode );
   for (i = 0; i < NTRACK; i++) {
      fwriteword(temp_trackarray[i].name,         9*i + 8,  7, g_emph_attrib,
                g_text_mode);
      write_int (temp_trackarray[i].midichan + 1, 9*i + 10, 8, g_emph_attrib);
      write_int ((int)temp_trackarray[i].numevents, 9*i+10, 9, g_emph_attrib);
   }

   fwriteword( g_songtitle, 26, 13, g_emph_attrib, g_text_mode );
   for (i = 0; i < NTRACK; i++) {
      fwriteword(g_trackarray[i].name,         9*i + 8,  15, g_emph_attrib,
                 g_text_mode);
      write_int (g_trackarray[i].midichan + 1, 9*i + 10, 16, g_emph_attrib);
      write_int ((int)g_trackarray[i].numevents, 9*i+10, 17, g_emph_attrib);
   }

   if (temp_meter != g_meter) {     /* warn if the meters don't match */
      strcpy( buf, "Note: Song in memory has meter = ");
      itoa( g_meter, nbuf, 10 );
      strcat( buf, nbuf );
      strcat( buf, ", Source meter = ");
      itoa( temp_meter, nbuf, 10 );
      strcat( buf, nbuf );
      writerr( buf, g_text_char_v, g_norm_attrib, g_norm_attrib );
   }

   pick = source_track = dest_track = 0;
   show_source( source_track );         /* highlight the default source */
   show_dest( dest_track );             /* and destination tracks on menu */

   /* Source and destination track selection rows on the import screen   */
   /* are elements of the mt51[] and mt52[] menus.  finitscrn is used to */
   /* display the items.  Changed selections are made by updating the    */
   /* menu's "content" fields in show_source() and show_dest().          */

   while (1) {
      finitscrn( mt51, 0, NTRACK - 1, g_emph_attrib, g_text_mode );
      finitscrn( mt52, 0, NTRACK - 1, g_emph_attrib, g_text_mode );
      finitscrn( mt5, 0, NPARAM5 - 1, g_emph_attrib, g_text_mode );

      pick = movescrn( g_text_mode, mt5, pick, NPARAM5 - 1, g_emph_attrib,
                                                            g_cursor_attrib );
      switch (pick) {
      case 0:           /* pick source track */
         source_track = movescrn( g_text_mode, mt51, dest_track, NTRACK - 1,
                                  g_emph_attrib, g_cursor_attrib );
         if (source_track >= 0)
            show_source( source_track );
         break;
      case 1:           /* pick dest. track */
         dest_track = movescrn( g_text_mode, mt52, source_track, NTRACK - 1,
                                  g_emph_attrib, g_cursor_attrib );
         if (dest_track >= 0)
            show_dest( dest_track );
         break;
      case 2:           /* import selected track */
         while (kbhit())
            getch();
         if (g_trackarray[dest_track].numevents > 1) {
            writeword(
                "Existing data in Dest track will be written over. OK?", 1,
                g_text_char_v - 1, g_norm_attrib );
            ans = getche();
            clearline( g_text_char_v - 1, g_norm_attrib );
            if (toupper(ans) != 'Y')
               break;
         }
         clearline( g_text_char_v - 1, g_norm_attrib );
         writeword("Importing track data...", 1, g_text_char_v - 1,
                                                 g_norm_attrib );
         import_track( stream, source_track, dest_track, temp_trackarray );
         fclose(stream);
         chdir(g_prodir);
         g_current_measure = 0;
         change_channel( dest_track, g_trackarray[dest_track].midichan );
         return;
      case  3:          /* quit */
      case -2:          /* ESC key */
         fclose(stream);
         chdir(g_prodir);
         return;
      } /* endswitch */
   }
}


/* Reads in one track's data by skipping over track data on disk for prior */
/* tracks, then building a new event list for the selected track as the    */
/* data is being read off of the disk.  Old data on dest. track is purged. */
void
import_track( FILE *stream, int source_track, int dest_track,
                                struct trackdata temp_trackarray[] )
{
   int i, j, events;
   struct event far *ep, far *lp;

   lp = eventalloc();                   /* lp points to a safe place */
   ep = g_trackarray[dest_track].first;
   clear_events( ep->next );            /* erase existing data in track */
   g_trackarray[dest_track].current = ep;

   for (i = 0; i < source_track; i++) {     /* run through data ahead */
      events = (int)temp_trackarray[i].numevents;  /* of source track */
      for (j = 0; j < events; j++)
         fget_from_file( &lp->nbytes, 5, stream );
   }
                /* each event is copied to over the lp memory area */
#ifdef TURBOC
   farfree
#else
   _ffree       /* no longer need dummy lp event to write over */
#endif
   (lp);
                                        /* read source track into memory */
   events = (int)temp_trackarray[source_track].numevents;
   for (j = 0; j < events; j++) {
      fget_from_file( &ep->nbytes, 5, stream );
      lp = ep;
      ep = ep->next = eventalloc();     /* add new events to list for data */
   }
#ifdef TURBOC
   farfree
#else
   _ffree
#endif
   (ep);
   lp->next = NULL;
   g_trackarray[dest_track].last = lp;
   g_trackarray[dest_track].numevents = events;
   g_trackarray[dest_track].midivol = 100;
}


void
show_source( int track )        /* update import menu for selected track */
{
   int i;

   for (i = 0; i < NTRACK; i++)
      if (i == track)
         strcpy( mt51[i].content, "*Source*");
      else
         strcpy( mt51[i].content, "        ");
}


void
show_dest( int track )          /* update import menu for destination track */
{
   int i;

   for (i = 0; i < NTRACK; i++)
      if (i == track)
         strcpy( mt52[i].content, "**Dest**");
      else
         strcpy( mt52[i].content, "        ");
}
