/* mtscreen.h */

/* screen data for cursor movement.  Format for selement is: */
/* row, col, title, nup, ndown, nleft, nright, key */


/* main menu */

struct selement mt1[NPARAM1] = {
	{ 5, 8, "DRIVE", 0, 1, 0, 0, 0 },
	{ 5, 9, "LOAD", 0, 2, 1, 1, 1 },
	{ 5, 10, "EDIT", 1, 3, 2, 2, 2 },
	{ 5, 11, "RECORD", 2, 4, 3, 3, 3 },
	{ 5, 12, "TITLE", 3, 5, 4, 4, 4 },
	{ 5, 13, "SAVE", 4, 6, 5, 5, 5 },
	{ 5, 14, "CLEAR", 5, 7, 6, 6, 6 },
	{ 5, 15, "IMPORT", 6, 8, 7, 7, 7 },
	{ 5, 16, "HELP", 7, 9, 8, 8, 8 },
	{ 5, 18, "QUIT", 8, 9, 9, 9, 9 },
};

/* record menu */
/* key entry is track number */

struct selement mt2[NPARAM2] = {
	{ 8, 5, "       ", 0, 8, 0, 1, 0 },
	{ 17, 5, "       ", 1, 9, 0, 2, 1 },
	{ 26, 5, "       ", 2, 10, 1, 3, 2 },
	{ 35, 5, "       ", 3, 11, 2, 4, 3 },
	{ 44, 5, "       ", 4, 12, 3, 5, 4 },
	{ 53, 5, "       ", 5, 13, 4, 6, 5 },
	{ 62, 5, "       ", 6, 14, 5, 7, 6 },
	{ 71, 5, "       ", 7, 15, 6, 7, 7 },
	{ 10, 6, "    ", 0, 16, 8, 9, 8 },
	{ 19, 6, "    ", 1, 17, 8, 10, 9 },
	{ 28, 6, "    ", 2, 18, 9, 11, 10 },
	{ 37, 6, "    ", 3, 19, 10, 12, 11 },
	{ 46, 6, "    ", 4, 20, 11, 13, 12 },
	{ 55, 6, "    ", 5, 21, 12, 14, 13 },
	{ 64, 6, "    ", 6, 22, 13, 15, 14 },
	{ 73, 6, "    ", 7, 23, 14, 15, 15 },
	{ 8, 7, "       ", 8, 24, 16, 17, 16 },
	{ 17, 7, "       ", 9, 25, 16, 18, 17 },
	{ 26, 7, "       ", 10, 26, 17, 19, 18 },
	{ 35, 7, "       ", 11, 27, 18, 20, 19 },
	{ 44, 7, "       ", 12, 28, 19, 21, 20 },
	{ 53, 7, "       ", 13, 29, 20, 22, 21 },
	{ 62, 7, "       ", 14, 30, 21, 23, 22 },
	{ 71, 7, "       ", 15, 31, 22, 23, 23 },
	{ 10, 8, "    ", 16, 32, 24, 25, 24 },
	{ 19, 8, "    ", 17, 33, 24, 26, 25 },
	{ 28, 8, "    ", 18, 34, 25, 27, 26 },
	{ 37, 8, "    ", 19, 35, 26, 28, 27 },
	{ 46, 8, "    ", 20, 36, 27, 29, 28 },
	{ 55, 8, "    ", 21, 37, 28, 30, 29 },
	{ 64, 8, "    ", 22, 38, 29, 31, 30 },
	{ 73, 8, "    ", 23, 39, 30, 31, 31 },
	{ 10, 9, "    ", 24, 40, 32, 33, 32 },
	{ 19, 9, "    ", 25, 41, 32, 34, 33 },
	{ 28, 9, "    ", 26, 42, 33, 35, 34 },
	{ 37, 9, "    ", 27, 43, 34, 36, 35 },
	{ 46, 9, "    ", 28, 44, 35, 37, 36 },
	{ 55, 9, "    ", 29, 45, 36, 38, 37 },
	{ 64, 9, "    ", 30, 46, 37, 39, 38 },
	{ 73, 9, "    ", 31, 47, 38, 39, 39 },
	{ 10, 10, "    ", 32, 48, 40, 41, 40 },
	{ 19, 10, "    ", 33, 49, 40, 42, 41 },
	{ 28, 10, "    ", 34, 50, 41, 43, 42 },
	{ 37, 10, "    ", 35, 51, 42, 44, 43 },
	{ 46, 10, "    ", 36, 52, 43, 45, 44 },
	{ 55, 10, "    ", 37, 53, 44, 46, 45 },
	{ 64, 10, "    ", 38, 54, 45, 47, 46 },
	{ 73, 10, "    ", 39, 55, 46, 47, 47 },
	{ 10, 11, "    ", 40, 56, 48, 49, 48 },
	{ 19, 11, "    ", 41, 57, 48, 50, 49 },
	{ 28, 11, "    ", 42, 57, 49, 51, 50 },
	{ 37, 11, "    ", 43, 58, 50, 52, 51 },
	{ 46, 11, "    ", 44, 58, 51, 53, 52 },
	{ 55, 11, "    ", 45, 59, 52, 54, 53 },
	{ 64, 11, "    ", 46, 59, 53, 55, 54 },
	{ 73, 11, "    ", 47, 59, 54, 55, 55 },
	{ 9, 14, "RECORD", 48, 63, 56, 57, 56 },
	{ 23, 14, "Last Measure", 49, 60, 56, 58, 57 },
	{ 41, 14, "Erase Track", 51, 61, 57, 59, 58 },
	{ 61, 14, "Metronome", 54, 62, 58, 59, 59 },
	{ 23, 15, "Fast Forwd >>", 57, 64, 63, 61, 60 },
	{ 41, 15, "Erase Forward", 58, 65, 60, 62, 61 },
	{ 61, 15, "Meter Bt/Mes", 59, 66, 61, 62, 62 },
	{ 10, 16, "PLAY", 56, 69, 63, 64, 63 },
	{ 23, 16, "Forward    >", 60, 67, 63, 65, 64 },
	{ 41, 16, "Data Dump", 61, 67, 64, 66, 65 },
	{ 61, 16, "Beats/Min.", 62, 68, 65, 66, 66 },
	{ 23, 17, "Rewind     <", 64, 70, 63, 65, 67 },
	{ 61, 17, "Pitch Bend", 66, 71, 65, 68, 68 },
	{ 6, 18, "All Notes Off", 63, 72, 69, 70, 69 },
	{ 23, 18, "Fast Rewnd <<", 67, 73, 69, 65, 70 },
	{ 61, 18, "Exclusive", 68, 74, 65, 71, 71 },
	{ 6, 19, "QUIT Record", 69, 72, 72, 73, 72 },
	{ 23, 19, "First Measure", 70, 73, 72, 74, 73 },
	{ 61, 19, "Data Trace", 71, 74, 73, 74, 74 },
};

/* measure level edit menu */

struct selement mt3[NPARAM3] = {
	{ 20, 3, " ", 0, 17, 16, 1, 0 },
	{ 24, 3, " ", 1, 18, 0, 2, 1 },
	{ 28, 3, " ", 2, 19, 1, 3, 2 },
	{ 32, 3, " ", 3, 20, 2, 4, 3 },
	{ 36, 3, " ", 4, 21, 3, 5, 4 },
	{ 40, 3, " ", 5, 22, 4, 6, 5 },
	{ 44, 3, " ", 6, 23, 5, 7, 6 },
	{ 48, 3, " ", 7, 24, 6, 8, 7 },
	{ 52, 3, " ", 8, 25, 7, 9, 8 },
	{ 56, 3, " ", 9, 26, 8, 10, 9 },
	{ 60, 3, " ", 10, 27, 9, 11, 10 },
	{ 64, 3, " ", 11, 28, 10, 12, 11 },
	{ 68, 3, " ", 12, 29, 11, 13, 12 },
	{ 72, 3, " ", 13, 30, 12, 14, 13 },
	{ 76, 3, " ", 14, 31, 13, 14, 14 },
	{ 4, 6, "       ", 0, 32, 15, 16, 15 },
	{ 14, 6, "  ", 0, 33, 15, 17, 16 },
	{ 20, 6, " ", 0, 34, 16, 18, 17 },
	{ 24, 6, " ", 1, 35, 17, 19, 18 },
	{ 28, 6, " ", 2, 36, 18, 20, 19 },
	{ 32, 6, " ", 3, 37, 19, 21, 20 },
	{ 36, 6, " ", 4, 38, 20, 22, 21 },
	{ 40, 6, " ", 5, 39, 21, 23, 22 },
	{ 44, 6, " ", 6, 40, 22, 24, 23 },
	{ 48, 6, " ", 7, 41, 23, 25, 24 },
	{ 52, 6, " ", 8, 42, 24, 26, 25 },
	{ 56, 6, " ", 9, 43, 25, 27, 26 },
	{ 60, 6, " ", 10, 44, 26, 28, 27 },
	{ 64, 6, " ", 11, 45, 27, 29, 28 },
	{ 68, 6, " ", 12, 46, 28, 30, 29 },
	{ 72, 6, " ", 13, 47, 29, 31, 30 },
	{ 76, 6, " ", 14, 48, 30, 31, 31 },
	{ 4, 7, "       ", 15, 49, 32, 33, 32 },
	{ 14, 7, "  ", 16, 50, 32, 34, 33 },
	{ 20, 7, " ", 17, 51, 33, 35, 34 },
	{ 24, 7, " ", 18, 52, 34, 36, 35 },
	{ 28, 7, " ", 19, 53, 35, 37, 36 },
	{ 32, 7, " ", 20, 54, 36, 38, 37 },
	{ 36, 7, " ", 21, 55, 37, 39, 38 },
	{ 40, 7, " ", 22, 56, 38, 40, 39 },
	{ 44, 7, " ", 23, 57, 39, 41, 40 },
	{ 48, 7, " ", 24, 58, 40, 42, 41 },
	{ 52, 7, " ", 25, 59, 41, 43, 42 },
	{ 56, 7, " ", 26, 60, 42, 44, 43 },
	{ 60, 7, " ", 27, 61, 43, 45, 44 },
	{ 64, 7, " ", 28, 62, 44, 46, 45 },
	{ 68, 7, " ", 29, 63, 45, 47, 46 },
	{ 72, 7, " ", 30, 64, 46, 48, 47 },
	{ 76, 7, " ", 31, 65, 47, 48, 48 },
	{ 4, 8, "       ", 32, 66, 49, 50, 49 },
	{ 14, 8, "  ", 33, 67, 49, 51, 50 },
	{ 20, 8, " ", 34, 68, 50, 52, 51 },
	{ 24, 8, " ", 35, 69, 51, 53, 52 },
	{ 28, 8, " ", 36, 70, 52, 54, 53 },
	{ 32, 8, " ", 37, 71, 53, 55, 54 },
	{ 36, 8, " ", 38, 72, 54, 56, 55 },
	{ 40, 8, " ", 39, 73, 55, 57, 56 },
	{ 44, 8, " ", 40, 74, 56, 58, 57 },
	{ 48, 8, " ", 41, 75, 57, 59, 58 },
	{ 52, 8, " ", 42, 76, 58, 60, 59 },
	{ 56, 8, " ", 43, 77, 59, 61, 60 },
	{ 60, 8, " ", 44, 78, 60, 62, 61 },
	{ 64, 8, " ", 45, 79, 61, 63, 62 },
	{ 68, 8, " ", 46, 80, 62, 64, 63 },
	{ 72, 8, " ", 47, 81, 63, 65, 64 },
	{ 76, 8, " ", 48, 82, 64, 65, 65 },
	{ 4, 9, "       ", 49, 83, 66, 67, 66 },
	{ 14, 9, "  ", 50, 84, 66, 68, 67 },
	{ 20, 9, " ", 51, 85, 67, 69, 68 },
	{ 24, 9, " ", 52, 86, 68, 70, 69 },
	{ 28, 9, " ", 53, 87, 69, 71, 70 },
	{ 32, 9, " ", 54, 88, 70, 72, 71 },
	{ 36, 9, " ", 55, 89, 71, 73, 72 },
	{ 40, 9, " ", 56, 90, 72, 74, 73 },
	{ 44, 9, " ", 57, 91, 73, 75, 74 },
	{ 48, 9, " ", 58, 92, 74, 76, 75 },
	{ 52, 9, " ", 59, 93, 75, 77, 76 },
	{ 56, 9, " ", 60, 94, 76, 78, 77 },
	{ 60, 9, " ", 61, 95, 77, 79, 78 },
	{ 64, 9, " ", 62, 96, 78, 80, 79 },
	{ 68, 9, " ", 63, 97, 79, 81, 80 },
	{ 72, 9, " ", 64, 98, 80, 82, 81 },
	{ 76, 9, " ", 65, 99, 81, 82, 82 },
	{ 4, 10, "       ", 66, 100, 83, 84, 83 },
	{ 14, 10, "  ", 67, 101, 83, 85, 84 },
	{ 20, 10, " ", 68, 102, 84, 86, 85 },
	{ 24, 10, " ", 69, 103, 85, 87, 86 },
	{ 28, 10, " ", 70, 104, 86, 88, 87 },
	{ 32, 10, " ", 71, 105, 87, 89, 88 },
	{ 36, 10, " ", 72, 106, 88, 90, 89 },
	{ 40, 10, " ", 73, 107, 89, 91, 90 },
	{ 44, 10, " ", 74, 108, 90, 92, 91 },
	{ 48, 10, " ", 75, 109, 91, 93, 92 },
	{ 52, 10, " ", 76, 110, 92, 94, 93 },
	{ 56, 10, " ", 77, 111, 93, 95, 94 },
	{ 60, 10, " ", 78, 112, 94, 96, 95 },
	{ 64, 10, " ", 79, 113, 95, 97, 96 },
	{ 68, 10, " ", 80, 114, 96, 98, 97 },
	{ 72, 10, " ", 81, 115, 97, 99, 98 },
	{ 76, 10, " ", 82, 116, 98, 99, 99 },
	{ 4, 11, "       ", 83, 117, 100, 101, 100 },
	{ 14, 11, "  ", 84, 118, 100, 102, 101 },
	{ 20, 11, " ", 85, 119, 101, 103, 102 },
	{ 24, 11, " ", 86, 120, 102, 104, 103 },
	{ 28, 11, " ", 87, 121, 103, 105, 104 },
	{ 32, 11, " ", 88, 122, 104, 106, 105 },
	{ 36, 11, " ", 89, 123, 105, 107, 106 },
	{ 40, 11, " ", 90, 124, 106, 108, 107 },
	{ 44, 11, " ", 91, 125, 107, 109, 108 },
	{ 48, 11, " ", 92, 126, 108, 110, 109 },
	{ 52, 11, " ", 93, 127, 109, 111, 110 },
	{ 56, 11, " ", 94, 128, 110, 112, 111 },
	{ 60, 11, " ", 95, 129, 111, 113, 112 },
	{ 64, 11, " ", 96, 130, 112, 114, 113 },
	{ 68, 11, " ", 97, 131, 113, 115, 114 },
	{ 72, 11, " ", 98, 132, 114, 116, 115 },
	{ 76, 11, " ", 99, 133, 115, 116, 116 },
	{ 4, 12, "       ", 100, 134, 117, 118, 117 },
	{ 14, 12, "  ", 101, 135, 117, 119, 118 },
	{ 20, 12, " ", 102, 136, 118, 120, 119 },
	{ 24, 12, " ", 103, 137, 119, 121, 120 },
	{ 28, 12, " ", 104, 138, 120, 122, 121 },
	{ 32, 12, " ", 105, 139, 121, 123, 122 },
	{ 36, 12, " ", 106, 140, 122, 124, 123 },
	{ 40, 12, " ", 107, 141, 123, 125, 124 },
	{ 44, 12, " ", 108, 142, 124, 126, 125 },
	{ 48, 12, " ", 109, 143, 125, 127, 126 },
	{ 52, 12, " ", 110, 144, 126, 128, 127 },
	{ 56, 12, " ", 111, 145, 127, 129, 128 },
	{ 60, 12, " ", 112, 146, 128, 130, 129 },
	{ 64, 12, " ", 113, 147, 129, 131, 130 },
	{ 68, 12, " ", 114, 148, 130, 132, 131 },
	{ 72, 12, " ", 115, 149, 131, 133, 132 },
	{ 76, 12, " ", 116, 150, 132, 133, 133 },
	{ 4, 13, "       ", 117, 151, 134, 135, 134 },
	{ 14, 13, "  ", 118, 151, 134, 136, 135 },
	{ 20, 13, " ", 119, 151, 135, 137, 136 },
	{ 24, 13, " ", 120, 152, 136, 138, 137 },
	{ 28, 13, " ", 121, 152, 137, 139, 138 },
	{ 32, 13, " ", 122, 152, 138, 140, 139 },
	{ 36, 13, " ", 123, 152, 139, 141, 140 },
	{ 40, 13, " ", 124, 152, 140, 142, 141 },
	{ 44, 13, " ", 125, 153, 141, 143, 142 },
	{ 48, 13, " ", 126, 153, 142, 144, 143 },
	{ 52, 13, " ", 127, 153, 143, 145, 144 },
	{ 56, 13, " ", 128, 153, 144, 146, 145 },
	{ 60, 13, " ", 129, 153, 145, 147, 146 },
	{ 64, 13, " ", 130, 153, 146, 148, 147 },
	{ 68, 13, " ", 131, 153, 147, 149, 148 },
	{ 72, 13, " ", 132, 153, 148, 150, 149 },
	{ 76, 13, " ", 133, 153, 149, 150, 150 },
	{ 13, 16, "Start Block", 135, 154, 151, 152, 151 },
	{ 32, 16, "Last Measure", 139, 155, 151, 153, 152 },
	{ 50, 16, "Curnt Measure", 143, 156, 152, 153, 153 },
	{ 13, 17, "End Block", 151, 157, 154, 155, 154 },
	{ 32, 17, "Fast Forwd >>", 152, 158, 154, 156, 155 },
	{ 50, 17, "Erase Track", 153, 159, 155, 156, 156 },
	{ 13, 18, "Block Paste", 154, 160, 157, 158, 157 },
	{ 32, 18, "Forward    >", 155, 161, 157, 159, 158 },
	{ 50, 18, "Erase Forward", 156, 162, 158, 159, 159 },
	{ 13, 19, "Block Empty", 157, 163, 160, 161, 160 },
	{ 32, 19, "Rewind     <", 158, 164, 160, 162, 161 },
	{ 50, 19, "Data Dump", 159, 167, 161, 162, 162 },
	{ 13, 20, "Block Repeat", 160, 165, 163, 164, 163 },
	{ 32, 20, "Fast Rewnd <<", 161, 166, 163, 162, 164 },
	{ 13, 21, "Block Transp.", 163, 165, 165, 166, 165 },
	{ 32, 21, "First Measure", 164, 166, 165, 167, 166 },
	{ 50, 21, "QUIT Edit", 162, 167, 166, 167, 167 },
};

/* help menu */

struct selement mt4[NPARAM4] = {
	{ 4, 9, "GENERAL", 0, 1, 0, 0, 0 },
	{ 4, 10, "MOUSE", 0, 2, 1, 1, 1 },
	{ 4, 11, "FILES", 1, 3, 2, 2, 2 },
	{ 4, 12, "EDITING", 2, 4, 3, 3, 3 },
	{ 4, 13, "RECORDING", 3, 5, 4, 4, 4 },
	{ 4, 14, "TITLES", 4, 6, 5, 5, 5 },
	{ 4, 15, "CLEAR", 5, 7, 6, 6, 6 },
	{ 4, 16, "IMPORT", 6, 8, 7, 7, 7 },
	{ 4, 18, "QUIT", 7, 8, 8, 8, 8 },
};

/* import menu */

/* bottom */

struct selement mt5[NPARAM5] = {
	{ 11, 21, "Pick Source", 0, 0, 0, 1, 0 },
	{ 29, 21, "Pick Dest.", 1, 1, 0, 2, 1 },
	{ 46, 21, "Import Track", 2, 2, 1, 3, 2 },
	{ 68, 21, "Quit", 3, 3, 2, 3, 3 },
};

/* source track selection */

struct selement mt51[NPARAM51] = {
	{ 8, 11, "       ", 0, 0, 0, 1, 0 },
	{ 17, 11, "       ", 1, 1, 0, 2, 1 },
	{ 26, 11, "       ", 2, 2, 1, 3, 2 },
	{ 35, 11, "       ", 3, 3, 2, 4, 3 },
	{ 44, 11, "       ", 4, 4, 3, 5, 4 },
	{ 53, 11, "       ", 5, 5, 4, 6, 5 },
	{ 62, 11, "       ", 6, 6, 5, 7, 6 },
	{ 71, 11, "       ", 7, 7, 6, 7, 7 },
};

/* destination track selection */

struct selement mt52[NPARAM52] = {
	{ 8, 19, "       ", 0, 0, 0, 1, 0 },
	{ 17, 19, "       ", 1, 1, 0, 2, 1 },
	{ 26, 19, "       ", 2, 2, 1, 3, 2 },
	{ 35, 19, "       ", 3, 3, 2, 4, 3 },
	{ 44, 19, "       ", 4, 4, 3, 5, 4 },
	{ 53, 19, "       ", 5, 5, 4, 6, 5 },
	{ 62, 19, "       ", 6, 6, 5, 7, 6 },
	{ 71, 19, "       ", 7, 7, 6, 7, 7 },
};

/* note editor menu */

struct selement mt6[NPARAM6] = {
	{ 1, 20, "Higher Octave", 0, 4, 0, 1, 0 },
	{ 20, 20, "Next Meas. >>", 1, 5, 0, 2, 1 },
	{ 42, 20, "Delete Note", 2, 6, 1, 3, 2 },
	{ 61, 20, "Tick =", 3, 7, 2, 3, 3 },
	{ 1, 21, "Lower Octave", 0, 8, 4, 5, 4 },
	{ 20, 21, "Next Beat  >", 1, 9, 4, 6, 5 },
	{ 42, 21, "Add Note", 2, 10, 5, 7, 6 },
	{ 61, 21, "Note =", 3, 11, 6, 7, 7 },
	{ 1, 22, "Expand <->", 4, 12, 8, 9, 8 },
	{ 20, 22, "Prev Beat  <", 5, 13, 8, 10, 9 },
	{ 42, 22, "Vel Change", 6, 14, 9, 11, 10 },
	{ 61, 22, "Measure =", 7, 15, 10, 11, 11 },
	{ 1, 23, "Shrink >-<", 8, 12, 12, 13, 12 },
	{ 20, 23, "Prev Meas. <<", 9, 13, 12, 14, 13 },
	{ 42, 23, "Quit Edit", 10, 14, 13, 15, 14 },
	{ 61, 23, "Top Note=", 11, 15, 14, 15, 15 },
};
