/* mtsc1.c  central module for screen editing functions of mt */
/* `MIDI Sequencing In C', Jim Conger, M&T Books, 1989 */

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>

#include "standard.h"
#include "screenf.h"
#include "mpu401.h"
#include "mt.h"
#include "video.h"
#include "mtsc.h"
#include "mtdeclar.h"


/* Central module for Note Level Editor.  Returns measure number ended on */
int
scrn_edit_control( int track, int measure )
{
   int beat = 0, pick;
   char buf[SCRNWIDE], nbuf[10];
   struct note_time far *note_list;

   setvideomode( g_graph_mode );

   strcpy( buf, "MIDI Note Editor  -  Track Number ");
   itoa( track + 1, nbuf, 10 );
   strcat( buf, nbuf );
   strcat( buf, ",  [");
   strcat( buf, g_trackarray[track].name );
   strcat( buf, "]");
   writeword( buf, 20, 1, g_norm_attrib );

   display_keyboard();
   mark_middle_c(TRUE);

   initscrn( mt6, 0, NPARAM6 - 1, g_emph_attrib );  /* put menu at bottom */
   init_screen_box( beat, measure );                /* draw in edit area */
   name_top_note( g_oct_shown );
   name_measure( measure );

   writeword("Compiling note data.  Hit ESC to terminate.", 1,
                g_graph_char_v, g_norm_attrib );
   note_list = build_note_list(track);              /* build note list */
   if (note_list == NULL) {
      writerr("ESC key hit (or not enough memory to compile note list).",
                g_graph_char_v, g_norm_attrib, g_emph_attrib );
      setvideomode( g_text_mode );
      return measure;
   }
   disp_notes( note_list, measure, beat );          /* draw note list */
   clearline( g_graph_char_v, g_norm_attrib );      /* clear bottom line */

   pick = 0;
   while (1) {                  /* cursor selection of a command */
      pick = movescrn( g_graph_mode, mt6, pick, NPARAM6 - 1, g_line_color,
                                                             g_line_color );
      switch (pick) {
      case 0:                   /* Up Octave */
         if (g_top_note < NNOTES - 12) {
             g_top_note += 12;
             g_bot_note += 12;
             name_top_note( g_oct_shown );
             mark_middle_c(FALSE);
             init_screen_box( beat, measure );
             disp_notes( note_list, measure, beat );
         }
         else
            writerr("You are at the top of the MIDI scale already.",
                        g_graph_char_v, g_norm_attrib, g_norm_attrib );
         break;
      case 1:                   /* Next Measure */
         measure++;
         name_measure( measure );
         init_screen_box( beat, measure );
         disp_notes( note_list, measure, beat );
         break;
      case 2:                   /* Note Delete */
         note_list = delete_note( note_list, measure, track );
      case 3:                   /* tick */
         break;
      case 4:                   /* Down Octave */
         if (g_top_note - ((g_oct_shown + 1) * 12) + 1 >= 0) {
             g_top_note -= 12;
             g_bot_note -= 12;
             name_top_note( g_oct_shown );
             mark_middle_c(FALSE);
             init_screen_box( beat, measure );
             disp_notes( note_list, measure, beat );
         }
         else
            writerr("You are already at the bottom of the MIDI scale.",
                        g_graph_char_v, g_norm_attrib, g_norm_attrib );
         break;
      case 5:                   /* Next Beat */
         if (beat < g_meter - 1)
             beat++;
         else {
             beat = 0;
             measure++;
         }
         name_measure( measure );
         init_screen_box( beat, measure );
         disp_notes( note_list, measure, beat );
         break;
      case 6:                   /* Note Add */
         add_note( note_list, measure, track );
      case 7:                   /* Note = */
         break;
      case 8:                   /* Expand Scale */
         if (g_scale > 1) {
             g_scale /= 2;
             init_screen_box( beat, measure );
             disp_notes( note_list, measure, beat );
         }
         else
            writerr("Already at the most expanded scale possible, 1/1.",
                        g_graph_char_v, g_norm_attrib, g_norm_attrib );
         break;
      case 9:                   /* Prev. Beat */
         if (beat > 0)
             beat--;
         else if (measure > 0) {
             measure--;
             beat = g_meter - 1;
         }
         name_measure( measure );
         init_screen_box( beat, measure );
         disp_notes( note_list, measure, beat );
         break;
      case 10:                  /* Velocity Change */
         change_vel( note_list, measure );
      case 11:                  /* Key Velocity (not an command) */
         break;
      case 12:                  /* Shrink Scale */
         if (g_scale < 8) {
             g_scale *= 2;
             init_screen_box( beat, measure );
             disp_notes( note_list, measure, beat );
         }
         else
            writerr("Scale already shrunk to maximum possible.",
                        g_graph_char_v, g_norm_attrib, g_norm_attrib );
         break;
      case 13:                  /* Prev Measure */
         if (measure) {
             measure--;
             name_measure( measure );
             init_screen_box( beat, measure );
	     disp_notes( note_list, measure, beat );
	 }
         else
            writerr("Already at beginning of track.",
                        g_graph_char_v, g_norm_attrib, g_norm_attrib );
         break;
      case 14:                  /* Quit */
      case -2:                  /* ESC */
         setvideomode(6);   /* kludge to get VGA back to 25 line */
         setvideomode( g_text_mode );
         return measure;
      default:
            writerr("Use arrow keys to make selection, then hit return.",
                        g_graph_char_v, g_norm_attrib, g_norm_attrib );
      } /* endswitch */
   }
}


/* Initialize global variables used in NLE graphics display */
/* based on video data read in on startup of MT. */
void
init_edit_param( void )
{
   int i, text_lines = SC_TOP_LINES + SC_MENU_LINES + SC_BOT_LINES;

   g_oct_shown = ( g_dots_v - text_lines * g_let_dots_v ) / OCTAVE_HIGH;
   g_top_note_line = SC_TOP_LINES * g_let_dots_v + HALF_NOTE_DOTS;
   g_bot_note_line = g_top_note_line + g_oct_shown * OCTAVE_HIGH -
						 2 * HALF_NOTE_DOTS;
   g_top_note = 71 + 6 * (g_oct_shown - 2);
   g_bot_note = g_top_note - 12 * g_oct_shown + 1;

   /* if in mode with more than 25 lines of text on screen */
   /* adjust the graphics menu to be at the bottom of screen. */

   if (g_graph_char_v > SCRNTALL)
      for (i = 0; i < NPARAM6; i++)
         mt6[i].ypos += g_graph_char_v - SCRNTALL;
}


void
display_keyboard( void )        /* put a keyboard image on left of screen */
{
   int m, n, y;

   y = g_top_note_line - HALF_NOTE_DOTS;
   for (m = 0; m < g_oct_shown; m++) {
      for (n = 0; n < 7; n++) {
         draw_rectangle( FALSE, 1, y, LEFT_BORDER - 2, y + 8, g_line_color );
         if (n  &&  n != 4  &&  n != 7)
            draw_rectangle( TRUE, 1, y - 2, (LEFT_BORDER - 2)/2, y + 2,
                                                              g_line_color );
         y += 2 * HALF_NOTE_DOTS;
      }
   }
}
