/* mtsc.h  header data for screen editor portion of mt */

#ifdef ALLOCATE

/* data in hex for bit mapped images */
/* sprite structure defined in screenf.h */

unsigned char lm[] =  {     /* bit map for small "m" used to mark middle C */
    0x82,
    0xc6,
    0xaa,
    0x92,
    0x82,
    0x82,
};

struct sprite little_m = { 1, 6, lm };

unsigned char dcross[] = {  /* bit map for cross for graphics cursor */
    0x08, 0x00,
    0x08, 0x00,
    0x08, 0x00,
    0x08, 0x00,
    0xF7, 0x80,
    0x08, 0x00,
    0x08, 0x00,
    0x08, 0x00,
    0x08, 0x00,
};

struct sprite cross = { 2, 9, dcross };


			    /* structure to hold note names and number of */
			    /* pixels to move up/down to get to next note */
struct note_map g_notes[] = {

    { "C -5",     4, 0 },       /* 0 */             /* MIDI note number */
    { "C#/Db -5", 4, 4 },
    { "D -5",     4, 4 },
    { "D#/Eb -5", 4, 4 },
    { "E -5",     8, 4 },
    { "F -5",     4, 8 },
    { "F#/Gb -5", 4, 4 },
    { "G -5",     4, 4 },
    { "G#/Ab -5", 4, 4 },
    { "A -5",     4, 4 },
    { "A#/Bb -5", 4, 4 },
    { "B -5",     8, 4 },

    { "C -4",     4, 8 },       /* 12 */
    { "C#/Db -4", 4, 4 },
    { "D -4",     4, 4 },
    { "D#/Eb -4", 4, 4 },
    { "E -4",     8, 4 },
    { "F -4",     4, 8 },
    { "F#/Gb -4", 4, 4 },
    { "G -4",     4, 4 },
    { "G#/Ab -4", 4, 4 },
    { "A -4",     4, 4 },
    { "A#/Bb -4", 4, 4 },
    { "B -4",     8, 4 },

    { "C -3",     4, 8 },       /* 24 */
    { "C#/Db -3", 4, 4 },
    { "D -3",     4, 4 },
    { "D#/Eb -3", 4, 4 },
    { "E -3",     8, 4 },
    { "F -3",     4, 8 },
    { "F#/Gb -3", 4, 4 },
    { "G -3",     4, 4 },
    { "G#/Ab -3", 4, 4 },
    { "A -3",     4, 4 },
    { "A#/Bb -3", 4, 4 },
    { "B -3",     8, 4 },

    { "C -2",     4, 8 },       /* 36 */
    { "C#/Db -2", 4, 4 },
    { "D -2",     4, 4 },
    { "D#/Eb -2", 4, 4 },
    { "E -2",     8, 4 },
    { "F -2",     4, 8 },
    { "F#/Gb -2", 4, 4 },
    { "G -2",     4, 4 },
    { "G#/Ab -2", 4, 4 },
    { "A -2",     4, 4 },
    { "A#/Bb -2", 4, 4 },
    { "B -2",     8, 4 },

    { "C -1",     4, 8 },       /* 48 */
    { "C#/Db -1", 4, 4 },
    { "D -1",     4, 4 },
    { "D#/Eb -1", 4, 4 },
    { "E -1",     8, 4 },
    { "F -1",     4, 8 },
    { "F#/Gb -1", 4, 4 },
    { "G -1",     4, 4 },
    { "G#/Ab -1", 4, 4 },
    { "A -1",     4, 4 },
    { "A#/Bb -1", 4, 4 },
    { "B -1",     8, 4 },

    { "C Mid.",   4, 8 },       /* 60 - middle C */
    { "C#/Db 1",  4, 4 },
    { "D 1",      4, 4 },
    { "D#/Eb 1",  4, 4 },
    { "E 1",      8, 4 },
    { "F 1",      4, 8 },
    { "F#/Gb 1",  4, 4 },
    { "G 1",      4, 4 },
    { "G#/Ab 1",  4, 4 },
    { "A 1",      4, 4 },
    { "A#/Bb 1",  4, 4 },
    { "B 1",      8, 4 },

    { "C 2",      4, 8 },       /* 72 */
    { "C#/Db 2",  4, 4 },
    { "D 2",      4, 4 },
    { "D#/Eb 2",  4, 4 },
    { "E 2",      8, 4 },
    { "F 2",      4, 8 },
    { "F#/Gb 2",  4, 4 },
    { "G 2",      4, 4 },
    { "G#/Ab 2",  4, 4 },
    { "A 2",      4, 4 },
    { "A#/Bb 2",  4, 4 },
    { "B 2",      8, 4 },

    { "C 3",      4, 8 },       /* 84 */
    { "C#/Db 3",  4, 4 },
    { "D 3",      4, 4 },
    { "D#/Eb 3",  4, 4 },
    { "E 3",      8, 4 },
    { "F 3",      4, 8 },
    { "F#/Gb 3",  4, 4 },
    { "G 3",      4, 4 },
    { "G#/Ab 3",  4, 4 },
    { "A 3",      4, 4 },
    { "A#/Bb 3",  4, 4 },
    { "B 3",      8, 4 },

    { "C 4",      4, 8 },       /* 96 */
    { "C#/Db 4",  4, 4 },
    { "D 4",      4, 4 },
    { "D#/Eb 4",  4, 4 },
    { "E 4",      8, 4 },
    { "F 4",      4, 8 },
    { "F#/Gb 4",  4, 4 },
    { "G 4",      4, 4 },
    { "G#/Ab 4",  4, 4 },
    { "A 4",      4, 4 },
    { "A#/Bb 4",  4, 4 },
    { "B 4",      8, 4 },

    { "C 5",      4, 8 },       /* 108 */
    { "C#/Db 5",  4, 4 },
    { "D 5",      4, 4 },
    { "D#/Eb 5",  4, 4 },
    { "E 5",      8, 4 },
    { "F 5",      4, 8 },
    { "F#/Gb 5",  4, 4 },
    { "G 5",      4, 4 },
    { "G#/Ab 5",  4, 4 },
    { "A 5",      4, 4 },
    { "A#/Bb 5",  4, 4 },
    { "B 5",      8, 4 },

    { "C 6",      4, 8 },       /* 120 */
    { "C#/Db 6",  4, 4 },
    { "D 6",      4, 4 },
    { "D#/Eb 6",  4, 4 },
    { "E 6",      8, 4 },
    { "F 6",      4, 8 },
    { "F#/Gb 6",  0, 4 },

};

#else

extern unsigned char dcross[];
extern struct sprite cross;
extern unsigned char lm[];
extern struct sprite little_m;
extern struct note_map g_notes[];

#endif
