/* mtrc1.c   recorder module for mt */
/* `MIDI Sequencing In C', Jim Conger, M&T Books, 1989 */

#include <stdio.h>  /* compiler library headers */
#include <conio.h>
#include <string.h>
#include <stdlib.h>

#include "screenf.h"
#include "standard.h"
#include "mpu401.h"
#include "mt.h"
#include "video.h"
#include "mtdeclar.h"


void
record_menu( void )             /* runs MT's record menu */
{
   int ans, pick, lastpick, track, param, x, *enter_int;
   char buf[80], nbuf[10];

   calc_pct_free();             /* update amount of free memory available */
   enter_int = &x;
   pick = 0;

   while (1) {
      init_track_str();                 /* put track names, etc. in menu */
      clearscreen( g_norm_attrib );     /* clear screen and display menu */
      fdispchain( g_chain[2], 1, g_norm_attrib, g_text_mode );

                                                /* put values at top */
      finitscrn( mt2, 0, NPARAM2 - 1, g_emph_attrib, g_text_mode );
      init_rec_val();                           /* put values at bottom */

      /* allow cursor movement to select a menu item, pick is item # */
      lastpick = pick;
      pick = movescrn( g_text_mode, mt2, pick, NPARAM2 - 1, g_emph_attrib,
                                                            g_cursor_attrib );

                        /* if at the top part of the record screen... */
      if (pick >= 0  &&  pick < NTRACK * N_TRACK_PARAM) {
         track = pick % NTRACK;
         param = (pick - track) / NTRACK;
         switch (param) {
         case 0:                /* track name */
            ans = getstr( g_text_char_v - 1, "Enter track name (8 chars max)->",
                        buf, 8, g_norm_attrib );
            if (ans) {
               strcpy( mt2[pick].content, buf );
               strcpy( g_trackarray[track].name, buf );
            }
            break;
         case 1:                /* midi channel number */
            ans = getint( g_text_char_v - 1,
                "Enter the MIDI channel number for this track (1-16)->",
                        enter_int, 1, 16, g_norm_attrib, g_emph_attrib );
            if (ans) {
               itoa( *enter_int, nbuf, 10 );
               strcpy( mt2[pick].content, nbuf );
               g_trackarray[track].midichan = --*enter_int;
               change_channel( track, *enter_int );
            }
            break;
         case 2:                /* track select toggle */
         case 4:                /* record toggle */
            if (g_record_track == track)
                g_record_track = -1;
            else
                g_record_track = track;
            break;
         case 3:                /* play toggle */
            if (g_trackarray[track].active)
                g_trackarray[track].active = 0;
            else {
                g_trackarray[track].active = 1;
                if (g_record_track == track)
                    g_record_track = -1;
            }
            break;
         case 5:                /* MIDI volume */
            ans = getint( g_text_char_v - 1, "Enter the MIDI volume (1-100)->",
                        enter_int, 1, 100, g_norm_attrib, g_emph_attrib );
            if (ans) {
               itoa( *enter_int, nbuf, 10 );
               strcpy( mt2[pick].content, nbuf );
               g_trackarray[track].midivol = *enter_int;
            }
            break;
         case 6:                /* bytes */
            writerr("You can not change this value - automatically set.",
                        g_text_char_v - 1, g_norm_attrib, g_emph_attrib );
            break;
         } /* endswitch */
      }
      else {    /* must be at the bottom, command part of record screen */
         switch (pick) {
         case 56:               /* RECORD */
            record();
            break;
         case 57:               /* End Tracks */
            g_current_measure = goto_measure(32000);
            break;
         case 58:               /* Erase track */
            erase_track();
            calc_pct_free();
            break;
         case 59:               /* Met On/Off */
            if (g_meton)
                g_meton = 0;
            else
                g_meton = 1;
            break;
         case 60:               /* Fast Forward */
            g_current_measure = goto_measure( g_current_measure + 10 );
            break;
         case 61:               /* Clear Forward */
            clear_forward();
            g_block_on = 0;
            calc_pct_free();
            break;
         case 62:               /* Beats/Measure */
            if (count_events() > NTRACK)
               writerr("You can only change meter if tracks are empty.",
                        g_text_char_v - 1, g_norm_attrib, g_emph_attrib );
            else {
               ans = getint( g_text_char_v - 1, "Enter beats per measure ->",
                        enter_int, 1, 20, g_norm_attrib, g_emph_attrib );
               if (ans == 1)
                  g_meter = *enter_int;
            }
            break;
         case 63:               /* PLAY */
            play();
            break;
         case 64:               /* Forward */
            g_current_measure = goto_measure( g_current_measure + 1 );
            break;
         case 65:               /* Data Dump */
            data_dump();
            break;
         case 66:               /* BPM */
            ans = getint( g_text_char_v - 1,
                        "Enter metronome rate in beeps/min ->",
			enter_int, 8, 250, g_norm_attrib, g_emph_attrib );
            if (ans == 1)
               g_metrate = *enter_int;
            break;
         case 67:               /* Rewind */
            g_current_measure = goto_measure( g_current_measure < 1  ?
                                        0  :  g_current_measure - 1 );
            break;
         case 68:               /* Pitch Bend toggle */
            if (g_pitchbend)
                g_pitchbend = 0;
            else
                g_pitchbend = 1;
            break;
         case 69:               /* All Notes Off */
            if (g_trace_on)
               trace_header();
            all_notes_off();
            if (g_trace_on)
               wait_for_key();
            break;
         case 70:               /* Fast Rewind */
            g_current_measure = goto_measure( g_current_measure < 10  ?
                                        0  :  g_current_measure - 10 );
            break;
         case 71:               /* Exclusive pass through On/Off */
            if (g_exclusive)
                g_exclusive = 0;
            else
                g_exclusive = 1;
            break;
         case 73:               /* Begin Tracks */
            g_current_measure = goto_measure(0);
            break;
         case 74:               /* Data Trace */
            if (g_trace_on)
                g_trace_on = 0;
            else
                g_trace_on = 1;
            break;
         case -2:               /* ESC key */
         case 72:               /* QUIT */
            return;
         default:
            writerr("Use arrow keys to move cursor, ret to select.",
                        g_text_char_v - 1, g_norm_attrib, g_emph_attrib );
            pick = lastpick;
         } /* endswitch */
      }
   }
}
