/* mted1.c   editor central module for mt */
/* `MIDI Sequencing In C', Jim Conger, M&T Books, 1989 */

#include <stdio.h>  /* compiler library headers */
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "screenf.h"
#include "standard.h"
#include "mpu401.h"
#include "mt.h"
#include "video.h"
#include "mtdeclar.h"


/* Controls the Measure Level Edit menu. */
void
edit_menu( void )
{
   int ans, pick, lastpick, track, item_no, enter_int, edit_measure;
   struct item meas_item;
   char buf[80], nbuf[10];

   pick = 0;
   while (1) {
      clearscreen( g_norm_attrib );     /* clear screen and display new one */
      fdispchain( g_chain[3], 1, g_norm_attrib, g_text_mode );

      /* initialize menu top for note symbols and track names, then display */
      init_meas_data();
      finitscrn( mt3, 0, NPARAM3 - 1, g_emph_attrib, g_text_mode );

      write_int( g_current_measure + 1, 64, 16, g_norm_attrib );
      calc_pct_free();                  /* update free memory value */
      write_int( g_pct_free_memory, 62, 20, g_norm_attrib );

      lastpick = pick;                  /* allow cursor selection of item */
      pick = movescrn( g_text_mode, mt3, pick, NPARAM3 - 1, g_emph_attrib,
                                                            g_cursor_attrib );
      /* if in the top half of the screen, track # and position can */
      /* be calculated from the menu item number (pick) selected. */

      track   = (pick - NMEASURE_DISP) / (NMEASURE_DISP + 2);
      item_no = (pick - NMEASURE_DISP) % (NMEASURE_DISP + 2);

      if (pick == -2)               /* Quit if ESC key */
         return;
      else if (pick < 0) {
         writerr("Use arrow keys to move cursor, ret to select.",
                        g_text_char_v - 1, g_norm_attrib, g_emph_attrib );
         pick = lastpick;
      }
                                    /* top line - select new start measure */
      else if (pick < NMEASURE_DISP) {
         goto_measure( g_current_measure + pick );
         g_current_measure += pick;
         pick = 0;
      }
                            /* see if the cursor is in the track data area */
      else if ( pick  <  NMEASURE_DISP * (NTRACK + 1)  +  2 * NTRACK ) {

         if (!item_no) {                /* track_name */
            ans = getstr( g_text_char_v - 1, "Enter track name (8 chars max)->",
                        buf, 8, g_norm_attrib );
            if (ans) {
	       strcpy( mt3[pick].content, buf );
               strcpy( g_trackarray[track].name, buf );
            }
         }
         else if (item_no == 1) {       /* MIDI channel number */
            ans = getint( g_text_char_v - 1,
                    "Enter the MIDI channel number for this track (1-16)->",
                    &enter_int, 1, 16, g_norm_attrib, g_emph_attrib );
            if (ans) {
               itoa( enter_int, nbuf, 10 );
	       strcpy( mt3[pick].content, nbuf );
               g_trackarray[track].midichan = --enter_int;
               change_channel( track, enter_int );
            }
         }
         else {         /* selected a measure for Note Level Edit */
            edit_measure = scrn_edit_control( track,
                                g_current_measure + item_no - 2 );

            /* on return from NLE, update measure cursor is on */

            if ( edit_measure >= g_current_measure   &&
                 edit_measure <  g_current_measure + NMEASURE_DISP ) {
               pick = NMEASURE_DISP  +  track * (NMEASURE_DISP + 2)  +
                              edit_measure - g_current_measure + 2;
               goto_measure( g_current_measure );
            }
            else {
               g_current_measure = goto_measure( edit_measure );
               pick = NMEASURE_DISP  +  track * (NMEASURE_DISP + 2)  +  2;
            }
         }
      }
      else {        /* must be bottom (command) area of MLE screen */
         switch (pick) {
         case 151:                      /* block start */
            if (g_block_on) {
               g_block_on = 0;          /* kill block if already on */
               g_block_start = g_block_end = -1;
            }
            else {
               writeword("Move the cursor to the first measure of the block.",
                        1, g_text_char_v - 1, g_norm_attrib );
               ans = select_measure( &meas_item );
               if (ans) {
                  g_block_track = meas_item.track;
                  g_block_start = meas_item.measure;
                  g_block_on = 1;
                  g_block_end = -1;

                  /* add empty measures if needed to extend track */
                  /* to measure selected for block start */
                  advance_to_measure( g_block_track, g_block_start + 1 );
               }
               else {
                  g_block_on = 0;
                  writerr("Measure not selected, so block cancelled.",
                        g_text_char_v, g_norm_attrib, g_norm_attrib );
               }
            }
            break;
         case 152:                      /* end tracks */
            g_current_measure = goto_measure( 32000 );
            g_current_measure -= 2; /* display last two measures */
            goto_measure( g_current_measure );
            break;
         case 153:                      /* measure no. */
            ans = getint( g_text_char_v - 1,
                    "Enter the measure number to start on ->",
                    &enter_int, 0, 32000, g_norm_attrib, g_emph_attrib );
            if (ans) {
               g_current_measure = enter_int - 1;
               goto_measure( g_current_measure );
            }
            break;
         case 154:                      /* Block End */
            writeword("Move the cursor to the last measure of the block.",
                        1, g_text_char_v - 1, g_norm_attrib );
            ans = select_measure( &meas_item );
            if (ans) {
               if (meas_item.track == g_block_track) {
                  g_block_end = meas_item.measure;
                  if (g_block_end < g_block_start) {
                     writerr("The block must end at or after start.",
                            g_text_char_v, g_norm_attrib, g_emph_attrib );
                     g_block_end = -1;
                  }
                  else          /* add measure data if off end of track */
                     advance_to_measure( g_block_track, g_block_end + 1 );
               }
               else {
                  writerr("The block must start and end on one track.",
                            g_text_char_v, g_norm_attrib, g_emph_attrib );
                  g_block_end = -1;
               }
            }
            break;
         case 155:                      /* Fast Forward */
            g_current_measure += 10;
            goto_measure( g_current_measure );
            break;
         case 156:                      /* Erase Track */
            erase_track();
            goto_measure( g_current_measure );
            calc_pct_free();
            g_block_on = 0;
            break;
         case 157:                      /* Block Paste */
            block_paste();
            calc_pct_free();
            break;
         case 158:                      /* Forward */
            goto_measure( ++g_current_measure );
            break;
         case 159:                      /* Erase Forward */
            clear_forward();
            g_block_on = 0;
            break;
         case 160:                      /* Block Empty */
            if (!g_block_on  ||  g_block_end == -1) {
               writerr("First mark the START and END of the block",
                        g_text_char_v - 1, g_norm_attrib, g_emph_attrib );
               break;
            }
            writeword(
                    "Are you sure you want to empty the marked block? (Y/N)->",
                    1, g_text_char_v - 1, g_norm_attrib );
            ans = getche();
            if (toupper(ans) == 'Y') {
               empty_block( g_block_track, g_block_start, g_block_end );
               calc_pct_free();
               g_block_on = 0;
               goto_measure( g_current_measure );
            }
            break;
         case 161:                      /* Rewind */
            g_current_measure = g_current_measure < 1  ?  0  :
                                g_current_measure - 1;
            goto_measure( g_current_measure );
            break;
         case 162:                      /* Data Dump */
            data_dump();
            break;
         case 163:                      /* Block Repeat */
            block_repeat();
            calc_pct_free();
            break;
         case 164:                      /* Fast Rewind */
            g_current_measure = g_current_measure < 10  ?  0  :
                                g_current_measure - 10;
            goto_measure( g_current_measure );
            break;
         case 165:                      /* Block Transpose */
            if (!g_block_on  ||  g_block_end == -1)
               writerr("First mark the START and END of the block",
                        g_text_char_v - 1, g_norm_attrib, g_emph_attrib );
            else
               transpose_block();
            break;
         case 166:                      /* Begin Tracks */
            g_current_measure = goto_measure(0);
            break;
         case 167:                      /* Quit */
            return;
         } /* endswitch */
      }
   }
}
