/* mt.h   header file for mt.c */

/* there is a nested include file referenced in the body of this file: */
/* mtscreen.h  -  all screen menu data */

/* see also mtdeclar.h - contains all function declarations */


/* These defines to allow same header file to work for both initialization */
/* and reference.  Only define the word ALLOCATE in the main() module. */

#ifdef	ALLOCATE    /* Global defined equal to nothing */
    #define GLOBAL
    #define INIT(x) =x
#else
    #define GLOBAL  extern
    #define INIT(x)
#endif		    /* INIT defined equal to nothing */


#define     NOTE_OFF	    0x80    /* MIDI voice messages - channel 1 */
#define     NOTE_ON	    0x90
#define     POLY_AFTERTOUCH 0xA0
#define     MODE_MESSAGE    0xB0
#define     PROGRAM_CHANGE  0xC0
#define     AFTERTOUCH	    0xD0
#define     PITCH_WHEEL     0xE0
#define     ALL_NOTES_OFF   0x7B    /* channel mode message */

/* IBM PC character graphic symbol numbers for Measure Level Edit screen */

#define     NOTE_CHAR	    14	    /* character for measure with data */
#define     MEAS_CHAR	    29	    /* character for measure with no data */
#define     BLOCK_START     195     /* character for start of block */
#define     BLOCK_END	    180     /* character for end of block */
#define     SMALL_BLOCK     199     /* character for 1 measure long block */

#define     NTRACK	    8	    /* number of tracks */
#define     NNOTES	    128     /* number of possible MIDI note numbers */
#define     NCHANNEL	    16	    /* maximum number of MIDI channels */
#define     OCTAVE	    12	    /* number of MIDI notes in a octave */
#define     TRACK_NAME_WIDE 9	    /* number of chars wide a name can be */
#define     TITLE_WIDE	    51	    /* number of chars for track title */
#define     N_TRACK_PARAM   7	    /* number of menu items per track */
#define     NMEASURE_DISP   15	    /* number of measures displayed */
#define     MAX_CLOCK	    240     /* highest MPU-401 clock value */
#define     FMALLOC_BYTES   4	    /* number of bytes used by fmalloc */

/* defines for mtsc modules */

#define     OCTAVE_HIGH     56	    /* number of dots high in one octave */
#define     CROSS_HALF	    4	    /* cross sprite half hight (to center) */
#define     SC_TOP_LINES    2	    /* space to reserve for text */
#define     SC_MENU_LINES   4	    /* space at screen bottom - menu lines */
#define     SC_BOT_LINES    2	    /* space at very bottom for messages */
#define     HALF_NOTE_DOTS  4	    /* pixel hight of half key on screen */
#define     LEFT_BORDER     70	    /* space in pixel dot widths */
#define     MIN_SPACE	    3	    /* min separation between MIDI tick */
#define     TICK_PER_BEAT   120     /* MPU tick per metronome beat */

#define     NSCREEN	5	/* number of screens */

/* defines the number of menu items on given screen */

#define     NPARAM1	10	/* main menu */
#define     NPARAM2	75	/* record menu */
#define     NPARAM3	168	/* measure level menu */
#define     NPARAM4	9	/* help menu */
#define     NPARAM5	4	/* import bottom menu */
#define     NPARAM51	8	/* source tracks of import */
#define     NPARAM52	8	/* destination tracks of import */
#define     NPARAM6	16	/* note level edit */

#define     DEFAULT_FILE_NAME	"NO_NAME.SNG"


/* global variables - all preceded by "g_" */

GLOBAL char g_prodir[50];	    /* directory of program's files */
GLOBAL char g_songdir[50];	    /* directory containing song data */
GLOBAL char g_filename[14]   INIT(DEFAULT_FILE_NAME);
GLOBAL char g_songtitle[TITLE_WIDE] INIT(" ");

GLOBAL int g_free_memory     INIT(0);	/* Kbytes of free memory at start */
GLOBAL int g_pct_free_memory INIT(0);	/* % of memory left to use */
GLOBAL int g_meton	     INIT(0);	/* toggle for metronome on/off */
GLOBAL int g_tick	     INIT(120); /* tick number within measure */
GLOBAL int g_metrate	     INIT(100); /* metronome rate */
GLOBAL int g_meter	     INIT(4);	/* beats per measure */
GLOBAL int g_midi_metro      INIT(24);	/* MPU midi clocks per metro beat */
GLOBAL int g_pitchbend	     INIT(0);	/* toggle for pitchbend data thru */
GLOBAL int g_exclusive	     INIT(0);	/* toggle for exclusive data thru */
GLOBAL int g_current_measure INIT(0);	/* number of current measure */
GLOBAL int g_record_track    INIT(-1);	/* track number set to record */
GLOBAL int g_bytes_used      INIT(0);	/* number of kbytes used */
GLOBAL int g_trace_on	     INIT(0);	/* toggle for data trace option on */

/* globals for mted modules */

GLOBAL int g_block_on	     INIT(0);	/* toggle for block active */
GLOBAL int g_block_track     INIT(-1);	/* track number for block */
GLOBAL int g_block_start     INIT(-1);	/* measure number for block start */
GLOBAL int g_block_end	     INIT(-1);	/* measure number for block end */

/* globals for mtsc modules */

GLOBAL int g_scale	     INIT(4);	/* amount of compression of time */
GLOBAL int g_oct_shown; 		/* number of octaves shown */
GLOBAL int g_top_note	     INIT(83);	/* MIDI note number of top note */
GLOBAL int g_top_note_line;		/* vert pixel number of top note */
GLOBAL int g_bot_note;			/* MIDI note number of bottom note */
GLOBAL int g_bot_note_line;		/* vert pixel number of bottom note */
GLOBAL int g_first_measure   INIT(0);	/* first measure number on screen */
GLOBAL int g_first_tick      INIT(0);	/* first tick number on screen */
GLOBAL int g_sc_refresh      INIT(1);	/* set true if note editor is left */

GLOBAL int g_note_array[NNOTES];    /* array to track which notes are left */
				    /* on of off at end of block */

GLOBAL int g_tracks_on[NTRACK]; 	/* tracks set to play */

GLOBAL int g_track_vel[NTRACK]; 	/* used to store velocity data for */
GLOBAL int g_track_vel_used  INIT(0);	/* play module. */


	/* structure definitions - for all modules in mt */

struct	event	{	/* structure used to store a midi data event */
    struct  event   far *next;
    unsigned char   nbytes;
    unsigned char   b[4];
};

struct	trackdata   {	/* structure to hold one track's data & pointers */
    char  name[TRACK_NAME_WIDE];
    int   midichan;
    long  numevents;
    int   active;
    int   midivol;
    struct  event   far *first;
    struct  event   far *current;
    struct  event   far *last;
};

struct	item	{   /* temporary structure used to pass data from functions */
    int track;
    int measure;
};

/* structures used in mtsc modules */

struct	note_map    {	/* Structure to hold data about each MIDI note no. */
    char  name[10];	/* Helps full screen display of piano, note name... */
    int   up_dots;	/* = number of pixels to go up to next note */
    int   down_dots;	/* = down to next note */
};

struct	note_time   {	/* note list structure used in full screen editing */
    struct  event   far *on_event;
    int     on_measure;
    int     on_tick;
    int     note_number;
    struct  event   far *off_event;
    int     off_measure;
    int     off_tick;
    struct  note_time	far *next;
};

/* structure used to keep track of note-ons when compiling note list */

struct	on_event    {
    struct  event   far *event;
    int measure;
    int tick;
    int vel;
};

/* temporary structure to pass measure/time/note of cursor position */

struct	note_pos    {
    int measure;
    int tick;
    int note;
    int sprite_x;
    int sprite_y;
};


/* The screen data definitions are too long for the INIT() approach, */
/* so different definitions are given depending on whether ALLOCATE is */
/* defined in the current module.  Look at the end of this file for the */
/* outline definitions of externals */

#ifdef	ALLOCATE
					/* primary data array for tracks */
    struct  trackdata	g_trackarray[NTRACK];
					/* pointers to screen image data */
					/* plus 1 so screens start #1, #2 */
    struct  strchain	*g_chain[NSCREEN + 1];

    char    g_note_char[2]   = { NOTE_CHAR, '\0' };   /* char strings for */
    char    g_meas_char[2]   = { MEAS_CHAR, '\0' };   /* measure level edit */
    char    g_blocks_char[2] = { BLOCK_START, '\0' }; /* symbols */
    char    g_blocke_char[2] = { BLOCK_END, '\0' };
    char    g_smallb_char[2] = { SMALL_BLOCK, '\0' };

#include "mtscreen.h"                   /* all menu data in this file */


#else	    /* external references for dependant modules */

    extern  struct  trackdata	g_trackarray[];
    extern  struct  strchain	*g_chain[];
    extern  struct  selement	mt1[];	  /* the menu data referenced here */
    extern  struct  selement	mt2[];	  /* is in mtscreen.h */
    extern  struct  selement	mt3[];
    extern  struct  selement	mt4[];
    extern  struct  selement	mt5[];
    extern  struct  selement	mt51[];
    extern  struct  selement	mt52[];
    extern  struct  selement	mt6[];
    extern  char    g_note_char[2];
    extern  char    g_meas_char[2];
    extern  char    g_blocks_char[2];
    extern  char    g_blocke_char[2];
    extern  char    g_smallb_char[2];

#endif
