/* mt.c       root module for 8 track sequencer/editor */
/* `MIDI Sequencing In C', Jim Conger, M&T Books, 1989 */

#include <stdio.h>      /* compiler library files */
#include <conio.h>
#include <stdlib.h>
#include <string.h>

#ifndef TURBOC
   #include <direct.h>	/* for getcwd() */
#endif

#include "standard.h"
#include "screenf.h"
#include "mpu401.h"

#define ALLOCATE        /* Because ALLOCATE is defined, all header data */
                        /* is stored at the beginning of this module.   */
#include "mt.h"         /* See mt.h for example use of ALLOCATE.        */
#include "video.h"
#include "filefunc.h"
#include "mtsc.h"
#include "mtdeclar.h"

/* main() controls MT's primary menu and directs */
/* execution to all other parts of the program.  */

void
main( void )
{
   int status, pick, lastpick, ans;

   clearscreen(BWC);
   writeword(
            "Loading  M T  -  Eight track MIDI Sequencer and Editor.",
    14,3,BWC);
   writeword(          "Version 1.20       Jim Conger 2/89",
    25,5,BWC);


   writeword( "PLEASE do not distribute copies of this software.", 16, 8, BWC);
   writeword(
        "Order `MIDI Sequencing In C' for program, source code, user's",10,10,BWC);
   writeword(
        "guide and documentation.  Contact M&T Books, 501 Galveston Dr.",10,11,BWC);
   writeword(
	"Redwood City, California, 94063.  Phone 800-533-4372 to order.",10,12,BWC);
   writeword(
        "In California 800-356-2002.  8AM to 5PM Pacific Standard Time.\n\n",
    10,13,BWC);


   getcwd( g_prodir, 50 );          /* put current directory name in dir */
   strcpy( g_songdir, g_prodir );   /* start with directory to program area */

   status = load_video_data("install.dat");
   if (!status) {
      writeword("Video data file install.dat not found - run INSTALL.",5,20,BWC);
      exit(0);
   }

   loadscrn( g_chain, NSCREEN, "mt");   /* load screens into memory */
   g_free_memory = free_memory();
   printf("\nFree memory = %d K bytes.", g_free_memory );

   init_edit_param();                   /* initialize data */
   init_tracks();

   writeword("Hit any key to start . . .", 28, 21, BWC );
   wait_for_key();


   /* Put the primary menu on the screen, plus current settings */
   /* Loop to and from dependent program segments based on selection */

   pick = 0;
   while (1) {
      clearscreen( g_norm_attrib );     /* clear screen, display main menu */
      fdispchain( g_chain[1], 1, g_norm_attrib, g_text_mode );

                                /* put directory and song name on screen */
      writeword( g_songdir,   47,  8, g_emph_attrib );
      writeword( g_filename,  47,  9, g_emph_attrib );
      writeword( g_songtitle, 26, 18, g_emph_attrib );

      lastpick = pick;          /* cursor selection of command */
      pick = movescrn( g_text_mode, mt1, pick, NPARAM1 - 1, g_norm_attrib,
                                                            g_cursor_attrib );
      switch (pick) {
      case 0:                           /* drive */
         getdrive( g_prodir, g_songdir );
         break;
      case 1:                           /* load */
         load_song();
         break;
      case 2:                           /* edit */
         edit_menu();
         break;
      case 3:                           /* record */
         record_menu();
         break;
      case 4:                           /* title */
         getstr( g_text_char_v - 1, "Enter title ->", g_songtitle,
            TITLE_WIDE - 1, g_norm_attrib );
         break;
      case 5:                           /* save */
         save_song();
         break;
      case 6:                           /* clear */
         writeword(
           "Are you sure you want to erase all track data in memory? (Y/N)->",
           1, g_text_char_v - 1, g_norm_attrib );
         ans = getche();
         if (toupper(ans) == 'Y') {
            erase_all();
            strcpy( g_songtitle, " ");
            strcpy( g_filename, "NO_NAME.SNG");
            init_tracks();
         }
         break;
      case 7:                           /* import */
         import_menu();
         break;
      case 8:                           /* help */
         help_control();
         break;
      case -2:                          /* ESC key */
      case( NPARAM1 - 1 ):              /* quit */
         writeword("Don't forget to SAVE data.  Quit? (Y/N) ",
                                1, g_text_char_v - 1, g_norm_attrib );
         ans = getche();
         if (toupper(ans) != 'Y') {
            pick = lastpick;
            break;
         }
         else {
            clearscreen(BWC);
            exit(0);
         }
      default:
         writerr("Use arrow keys to move cursor, ret to select.",
                g_text_char_v - 1, g_norm_attrib, g_emph_attrib );
         pick = lastpick;
      } /* endswitch */
   }
}
