/* inputf.c   functions for prompting user input */
/* `MIDI Sequencing In C', Jim Conger, M&T Books, 1989 */

#include <conio.h>      /* compiler library module headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "standard.h"           /* header files */
#include "screenf.h"

/* Get floating point no. from user.  RETURN enters value, ESC quits. */
/* Prompt string is printed on line number lineno with norm_attrib. */
/* If input is > max or < min, error message is printed on lineno */
/* with emph_attrib, and user is given another try. */
/*      Returns 1 if number was input, 0 if process was escaped. */
int
getfloat( int lineno, char *prompt, float *value, float min, float max,
          int norm_attrib, int emph_attrib )
{
   char input[20], minbuf[20], maxbuf[20], message[SCRNWIDE];
   int  n;
   float tempval;

   while (1) {
      while (kbhit())
         getch();       /* clear any stray keypress */
      clearline( lineno, norm_attrib );
      writeword( prompt, 1, lineno, norm_attrib );
      n = get_string( input, 19 );
      if (!n)
         return 0;
      tempval = (float)atof(input);

      if (tempval > max  ||  tempval < min) {
         gcvt( min, 3, minbuf );
         gcvt( max, 3, maxbuf );
         strcpy( message, "Value must be between ");
         strcat( message, minbuf );
         strcat( message, " and ");
         strcat( message, maxbuf );
         writerr(message, lineno, norm_attrib, emph_attrib );
      }
      else {
         *value = tempval;
         return 1;
      }
   }
}

/* Get integer value from user.  RETURN enters value, ESC quits. */
/* Prompt string is printed on line number lineno with norm_attrib. */
/* If input is > max or < min, error message is printed on lineno */
/* with emph_attrib, and user is given another try. */
/*      Returns 1 if number was input, 0 if process was escaped. */
int
getint( int lineno, char *prompt, int *value, int min, int max,
        int norm_attrib, int emph_attrib )
{
   char input[20], minbuf[20], maxbuf[20], message[SCRNWIDE];
   int  tempval, n;

   while (1) {
      while (kbhit())
         getch();       /* clear any stray keypress */
      clearline( lineno, norm_attrib );
      writeword( prompt, 1, lineno, norm_attrib );
      n = get_string( input, 19 );
      if (!n)
         return 0;
      tempval = atoi(input);

      if (tempval > max  ||  tempval < min) {
         itoa( min, minbuf, 10 );
         itoa( max, maxbuf, 10 );
         strcpy( message, "Value must be between ");
         strcat( message, minbuf );
         strcat( message, " and ");
         strcat( message, maxbuf );
         writerr(message, lineno, norm_attrib, emph_attrib );
      }
      else {
         *value = tempval;
         return 1;
      }
   }
}

/* Get input string of no more than max chars from user. */
/* Prompt string is printed on line number lineno with norm_attrib. */
/*      Returns number of characters input. */
int
getstr( int lineno, char *prompt, char *string, int max, int attrib )
{
   int n;

   clearline( lineno, attrib );
   while (kbhit())
      getch();
   writeword( prompt, 1, lineno, attrib );
   n = get_string( string, max );
   clearline( lineno, attrib );
   return n;
}

/* Clean version of fgets().  Returns no. of characters read, up to max */
/*      Returns 0 for just ENTER or if ESC is hit at any time. */
int
get_string( char *str, int max )
{
   int i, c;

   i = 0;
   while (1) {
      c = getch();
      if (c == ESC  ||  ( c == '\n' &&  i == 0 )) {
         *str = '\0';
         return 0;
      }
      else if (c == 0)          /* ignore arrow or function keys */
         getch();
      else if (c == '\r')       /* do not put a CR in string */
         break;
      else if (c == BACKSP) {   /* rub out on back space */
         if (i > 0) {
            *(--str) = ' ';
            i--;
            putch(BACKSP);
            putch(' ');
            putch(BACKSP);
         }
      }
      else if (iscntrl(c))      /* do not press other control chars */
         ;
      else {
         if (i < max)           /* do not advance past max chars */
            i++;
         else {
            str--;              /* just overwrite last char position */
            putch(BACKSP);
         }
         putch(c);
	 *str++ = (char)c;
      }
   }
   *str = '\0';
   return i;
}
