/* filefunc.c	standard file utilities */
/* `MIDI Sequencing in C', Jim Conger, M&T Books, 1989 */

/* #define TURBOC 1   Define if using Turbo C, leave out for Microsoft */

#include <conio.h>		/* compiler library module headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef TURBOC
   #include <dir.h>
#else
   #include <dos.h>
   #include <direct.h>
#endif

#include "standard.h"           /* header files */
#include "screenf.h"
#include "video.h"
#include "filefunc.h"           /* must be included to use pick_file */
#include "mtdeclar.h"


/* allow user to pick file matching wild card string */
/*  return number of choice in struct selement g_file_disp (see filefunc.h) */
int
pick_file( char *dir, char *match_str, char *str )
{
   char buf[SCRNWIDE];
   int	num_files, pick;

   num_files = disp_files( dir, match_str );
   if (!num_files) {
      strcpy( buf, "There are no files matching ");
      strcat( buf, match_str );
      strcat( buf, " on this drive/directory.");
      writerr( buf, g_text_char_v, g_norm_attrib, g_norm_attrib );
      return -1;
   }
   fwriteword( str, 1, g_text_char_v - 1, g_emph_attrib, g_text_mode );
   pick = movescrn( g_text_mode, g_file_disp, 0, num_files - 1, g_norm_attrib,
							    g_cursor_attrib );
   if (pick >= num_files)
      return -1;
   else
      return(pick);
}


/* display file names matching str, returns # of files displayed */
int
disp_files( char *dir, char *match_str )
{
   char buf[SCRNWIDE], *s;
   int	i, status;

#ifdef TURBOC
   struct ffblk ffblk;		/* defined in dir.h */
#else
   struct find_t c_file;	/* defined in dos.h */
#endif

   for (i = 0; i < NPARAM_FILE; i++)
      strcpy( g_file_disp[i].content, " ");

   clearscreen( g_norm_attrib );
   strcpy( buf, "Files matching ");
   strcat( buf, match_str );
   strcat( buf, " on your selected drive (" );
   strcat( buf, dir );
   strcat( buf, "):\n");
   writeword( buf, 1, 1, g_emph_attrib );

   strcpy( buf, dir );		/* build up full path\:*.XXX string for DOS */
      s = (char *)strchr( buf, '\0');
      if (*(--s) != '\\') {     /* add '\' if necessary */
	 *(++s) = '\\';
	 *(++s) = '\0';
      }
      strcat( buf, match_str );

#ifdef TURBOC
   status = findfirst( buf, &ffblk, 0 );
#else
   status = _dos_findfirst( buf, _A_NORMAL, &c_file );
#endif
   if (status)
      return 0;

   strcpy( g_file_disp[0].content,
#ifdef TURBOC
				  ffblk.name );
#else
				  c_file.name );     /* copy file names to */
#endif						     /* screen data array */

   i = 1;
   do {
#ifdef TURBOC
      status = findnext( &ffblk );
#else
      status = _dos_findnext( &c_file );
#endif
      if (status)
	 break;
      else
	 strcpy( g_file_disp[i].content,
#ifdef TURBOC
					ffblk.ff_name );
#else
					c_file.name );
#endif
   } while (++i < NPARAM_FILE );

   finitscrn( g_file_disp, 0, i - 1, g_norm_attrib, g_text_mode );
   return i;
}


int			/* prompt for drive/directpry to store data */
getdrive( char *prodir, char *sampdir )
{
   char tmpdir[51], errbuf[80];

   while (1) {
      if (getstr( g_text_char_v - 1, "Enter drive/directory ->", tmpdir, 50,
							    g_norm_attrib )) {
	 if (tmpdir[1] == '\0') {   /* convert C to C: */
	     tmpdir[1] = ':';
	     tmpdir[2] = '\0';
	 }
	 if (tmpdir[2] == '\0') {   /* convert C: to C:\ */
	     tmpdir[2] = '\\';
	     tmpdir[3] = '\0';
	 }
	 if (chdir(tmpdir) != -1) { /* make sure directory exists */
	    strcpy( sampdir, tmpdir );
	    chdir(prodir);
	    return 1;
	 }
	 else {
	    chdir( prodir );
	    strcpy( errbuf, "Could not open directory ");
	    strcat( errbuf, tmpdir );
	    writerr(errbuf, g_text_char_v, g_norm_attrib, g_emph_attrib );
	 }
      }
      else return 0;
   }
}


void						/* put near data to stream */
put_to_file( void *addr, int size, FILE *stream )
{
   int i;
   char *addr2;

   addr2 = (char *)addr;
   for (i = 0; i < size; i++)
      fputc( *addr2++, stream );
}


void						/* put far data to stream */
fput_to_file( void far *addr, int size, FILE *stream )
{
   int i;
   char far *addr2;

   addr2 = (char far *)addr;
   for (i = 0; i < size; i++)
      fputc( *addr2++, stream );
}


void			    /* get data from stream, put into near memory */
get_from_file( void *addr, int size, FILE *stream )
{
   int i;
   char *addr2;

   addr2 = (char *)addr;
   for (i = 0; i < size; i++)
      *addr2++ = (char)fgetc( stream );
}


void			    /* get data from stream, put into far memory */
fget_from_file( void far *addr, int size, FILE *stream )
{
   int i;
   char far *addr2;

   addr2 = (char far *)addr;
   for (i = 0; i < size; i++)
      *addr2++ = (char)fgetc( stream );
}


/* load screen files into memory as linked lists */
void
loadscrn( struct strchain *chain[], int number, char *namestr )
{
   int i;
   char nbuf[10], buf[50];

   fputs("\nLoading screen images....\n", stdout );

   for (i = 1; i <= number; i++) {
      strcpy( buf, namestr );	    /* screen images are "namestr"1.scr,... */
      nbuf[0] = (char)('0'+ i);	    /* (number = 1...9) */
      nbuf[1] = '\0';
      strcat( buf, nbuf );
      strcat( buf,".scr");
      chain[i] = inpchain( buf, SCRNWIDE + 1 );
   }
   for (i = 1; i <= number; i++) {
      if (chain[i] == NULL) {
	 fputs("Failed to load screen file ", stdout );
	 fputs( namestr, stdout );
	 itoa( i, buf, 10 );
	 fputs( buf, stdout );
	 fputs(".scr\n", stdout );
	 fputs("Be sure you run the program from the default drive.", stdout);
	 exit(0);
      }
   }
}


/* Load values from filename into global data defined in video.h.  This */
/* is the counterpart to the INSTALL program that builds a video data file. */
int
load_video_data( char *filename )
{
   FILE *infile;

   infile = fopen( filename, "r");
   if (infile == NULL)
      return 0;

   get_from_file( &g_text_mode,    sizeof(int), infile );
   get_from_file( &g_graph_mode,   sizeof(int), infile );
   get_from_file( &g_dots_v,	   sizeof(int), infile );
   get_from_file( &g_dots_h,	   sizeof(int), infile );
   get_from_file( &g_norm_attrib,  sizeof(int), infile );
   get_from_file( &g_cursor_attrib,sizeof(int), infile );
   get_from_file( &g_emph_attrib,  sizeof(int), infile );
   get_from_file( &g_let_dots_v,   sizeof(int), infile );
   get_from_file( &g_let_dots_h,   sizeof(int), infile );
   get_from_file( &g_text_char_h,  sizeof(int), infile );
   get_from_file( &g_text_char_v,  sizeof(int), infile );
   get_from_file( &g_graph_char_h, sizeof(int), infile );
   get_from_file( &g_graph_char_v, sizeof(int), infile );
   get_from_file( &g_text_colors,  sizeof(int), infile );
   get_from_file( &g_graph_colors, sizeof(int), infile );

   if (g_graph_colors >= 4) {
      g_line_color =  g_norm_attrib & 0x0F;
      g_back_color = (g_norm_attrib & 0xF0) >> 4;
      g_emph_color =  g_emph_attrib & 0x0F;
   }
   else {		/* for black/white display modes */
      g_line_color = 1;
      g_back_color = 0;
      g_emph_color = 1;
   }

   fclose(infile);
   return 1;
}
