/* chain.c - screen file storage and display */
/* uses linked lists with each node defined as a struct strchain */
/* `MIDI Sequencing In C', Jim Conger, M&T Books, 1989 */

/* #define TURBOC 1   Define if using Turbo C, leave out for Microsoft */

#include <stdio.h>
#include <string.h>

#ifdef TURBOC
   #include <alloc.h>	    /* Turbo C library file name */
#else
   #include <malloc.h>	    /* Microsoft C library file name */
#endif

#include "standard.h"
#include "screenf.h"        /* contains structure definition */

/* read file into a linked list (chain) in near memory */
/*	returns a pointer to the start of the linked list */
struct strchain
*inpchain( char *file, int maxlen )
{
   FILE  *stream;
   struct strchain *root;
   char  *strbuf;

   strbuf = (char *)malloc( maxlen + 1 );	/* set aside input buffer */

   stream = fopen( file, "r");

   root = NULL;
   while (fgets( strbuf, maxlen, stream ) != NULL)
      root = chain( root, strbuf );

   fclose(stream);
   free(strbuf);		/* free buff for other use */
   return(root);
}

/* add a string recursively to the end of a linked list */
/*	returns a pointer to the new node */
struct strchain
*chain( struct strchain *p, char *w )
{
   if (p == NULL) {
      p = chainalloc();
      p->line = strsave(w);
      p->next = NULL;
   }
   else
      p->next = chain( p->next, w );
   return p;
}

/* free all memory reserved for the linked list (chain) pointed to by p */
void
dechain( struct strchain *p )
{
   struct strchain *q;
   if (p != NULL) {
      q = p->next;
      free(p->line);
      free(p);
      dechain(q);
   }
}

/* write all lines of the linked list (chain) to stdout starting on line y. */
/*  Standard console output version.  Characters written with color attrib. */
void
dispchain( struct strchain *p, int y, int attrib )
{
   if (p) {
      writeword( p->line, 1, y, attrib );
      dispchain( p->next,  ++y, attrib );
   }
}

/* reserve memory space for next node in the linked list */
struct strchain
*chainalloc( void )
{
   return(( struct strchain *)malloc( sizeof( struct strchain )));
}

/* save a string to memory */
/*	reserves memory and returns a pointer to start */
char
*strsave( char *s )
{
   char *p;
   if ((p = (char *)malloc( strlen(s) + 1)) != NULL)
      strcpy(p,s);
   return p;
}

/* write all lines of list to console, FAST VERSION. */
/*  y = start line, p = pointer to start of linked list, mode = video mode */
void
fdispchain( struct strchain *p, int y, int attrib, int mode )
{
   if (p) {
      fwriteword( p->line, 1, y, attrib, mode );
      fdispchain( p->next,  ++y, attrib, mode );
   }
}
