/* buildmenu.c	makes up a struct selement array from screen file */
/*   assumes that each screen element which should be a cursor choice */
/*   is surrounded by a pair od { } chars.  Close elements can use just { */
/* jlc 6/88  rev 1 */
/*     9/88 converted to Microsoft graphics library row, col #'s */

/* #define TURBOC 1   Define if using Turbo C, leave out for Microsoft */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef TURBOC
    #include <alloc.h>
#else
    #include <malloc.h>
#endif

#include "standard.h"
#include "screenf.h"

#define MAXEL		500	/* max number of screen elements */
#define CONTENT_WIDE	15	/* char width of content, struct selement */
#define SCRN_PITCH	8	/* int ratio of row vs col dist on screen */
#define MINY_DIST	0	/* minimum significant vertical distance */
#define MINX_DIST	2	/* minimum significant horizontal distance */
/* (less and the items are considered to be on the same line vertically) */

/* the only function's prototype */

void write_instructions( void );


void
main(int argc, char *argv[])
{
   int *x, *y, i, j, numel, row, col, right_dis, left_dis, up_dis, down_dis,
      close_up, close_down, close_left, close_right, xdist, ydist, delx, dely;
   char c, *sp, nbuf[10], lbuf[SCRNWIDE], *str[MAXEL];
   FILE *infile, *outfile = stdout;

   if (argc < 2) {	/* if no input file - put up help info */
      write_instructions();
      exit(1);
   }
   else if (argc > 2) {	/* default output is stdout */
      outfile = fopen(argv[2], "w");
      if (outfile == NULL) {
	 fputs("\nCould not open output file.", stdout);
	 write_instructions();
	 exit(1);
      }
   }

   infile = fopen(argv[1], "r");
   if (infile == NULL) {
      fputs("\nCould not open input file.", stdout);
      write_instructions();
      exit(1);
   }


   x = (int *)malloc( MAXEL * sizeof(int));   /* allocate memory for arrays */
   y = (int *)malloc( MAXEL * sizeof(int));
   for (i = 0; i < MAXEL; i++)
      str[i] = (char *)malloc( CONTENT_WIDE * sizeof(char));
   numel = 0;
   col = row = 1;
   while (1) {		/* main loop, runs through every char in file */
      c = (char)fgetc(infile);
      switch (c) {
      case '\t':        /* expand tabs to blanks */
	 while (!(++col % TABSPACE));
	 break;
      case ('{'):       /* start of a menu item */
	 col++;
	 x[numel] = col;
	 y[numel] = row;
	 sp = str[numel];
	 i = 0;
	 do {		/* read chars until }, { or out of space */
	    c = (char)fgetc(infile);
	    if (c != '}' &&  c != '{')
	       *sp++ = c;
	    col++;
	 } while (i++ < CONTENT_WIDE  &&  c != '}' &&  c != '{' &&  c != EOF);
	 *sp = '\0';
	 numel++;
	 break;
      case '\n':        /* new line */
	 col = 1;
	 row++;
	 break;
      case EOF: 	/* end of file, so compute neighbours distance */
	 fclose(infile);
	 fputs("\n#define NPARAM  ", outfile);
	 itoa(numel, nbuf, 10);
	 fputs(nbuf, outfile);
	 fputs("\n\nstruct selement _______[NPARAM] = {\n", outfile);
	 for (i = 0; i < numel; i++) {
	    left_dis = right_dis = up_dis = down_dis = 32000;
					/* default nearest is same spot */
	    close_left = close_right = close_up = close_down = i;
					/* find nearest neighbours */
	    for (j = 0; j < numel; j++) {
	       delx = x[j] - x[i];
	       dely = y[j] - y[i];
		    /* note the factor for screen not square */
	       xdist = abs(delx) + (SCRN_PITCH * abs(dely));
	       ydist = abs(delx) + abs(dely);
	       if (delx > MINX_DIST) {		/* on the right side ? */
		  if (xdist < right_dis) {
		     right_dis = xdist;
		     close_right = j;
		  }
	       }
	       else if (delx < (-1)*MINX_DIST) {  /* on the left side ? */
		  if (xdist < left_dis) {
		     left_dis = xdist;
		     close_left = j;
		  }
	       }
	       if (dely > MINY_DIST) {		/* below ? */
		  if (ydist < down_dis) {
		     down_dis = ydist;
		     close_down = j;
		  }
	       }
	       else if (dely < (-1)*MINY_DIST) {  /* above ? */
		  if (ydist < up_dis) {
		     up_dis = ydist;
		     close_up = j;
		  }
	       }
	    }
	    strcpy(lbuf, "\t{ ");    /* write the structure def. line */
	    itoa(x[i], nbuf, 10);
	    strcat(lbuf, nbuf);
	    strcat(lbuf, ", ");
	    itoa(y[i], nbuf, 10);
	    strcat(lbuf, nbuf);
	    strcat(lbuf, ", \"");
	    strcat(lbuf, str[i]);
	    strcat(lbuf, "\", ");
	    itoa(close_up, nbuf, 10);
	    strcat(lbuf, nbuf);
	    strcat(lbuf, ", ");
	    itoa(close_down, nbuf, 10);
	    strcat(lbuf, nbuf);
	    strcat(lbuf, ", ");
	    itoa(close_left, nbuf, 10);
	    strcat(lbuf, nbuf);
	    strcat(lbuf, ", ");
	    itoa(close_right, nbuf, 10);
	    strcat(lbuf, nbuf);
	    strcat(lbuf, ", ");
	    itoa(i, nbuf, 10);
	    strcat(lbuf, nbuf);
	    strcat(lbuf, " },\n");
	    fputs(lbuf, outfile);
	 }
	 fputs("};\n", outfile);
	 exit(0);
      default: /* any other char - just move past it */
	 col++;
      } /* endswitch */
   }
}

void
write_instructions()
{
   fputs("\nBULDMENU - builds a cursor control file for use by writscrn.c,",
								  stdout);
   fputs("\nfunction movescrn().  Normally the output file is added to the",
								  stdout);
   fputs("\nprogram's header file as a struct of type selement.", stdout);
   fputs("\nEach element surrounded by { } characters becomes a menu item.",
								  stdout);
   fputs("\n\nUsage: buldmenu <inputfile> [<outputfile>]\n", stdout);
}
