/*

 File: MIKWAV.C

 Description:
  Demonstrates the loading and playing of sound effects through MikMod.
  This program also has commented out code that can be used to play a module
  while maintaining sound effects playback.

 Note:
  Change any of the PAN_LEFT, PAN_RIGHT, or PAN_CENTER values to PAN_SURROUND
  to do Dolby surround sound back-channel panning.

*/

#include <conio.h>
#include "mikmod.h"
#include "getopt.h"


void main(void)
{
    BOOL   quit = 0;
    SAMPLE *explode, *mecha, *slash;
    int    exp_voice, mech_voice, slash_voice;


    // =======================================
    // Register all std loaders and drivers for use.

    MikMod_RegisterAllLoaders();
    MikMod_RegisterAllDrivers();

    // ===================================================================
    // Initialize MikMod (initializes soundcard and associated mixers, etc)

    MikMod_Init();
    MikMod_SetNumVoices(0,4);   // 0 music voices; 4 sound effects voices!

    printf("Using %s for %d bit %s %s sound at %u Hz\n\n",
           md_driver->Name,
           (md_mode&DMODE_16BITS) ? 16:8,
           (md_mode&DMODE_INTERP) ? "interpolated" : "normal",
           (md_mode&DMODE_STEREO) ? "stereo" : "mono",
           md_mixfreq);

#ifdef __OS2__
    DosSetPriority( PRTYS_THREAD, PRTYC_TIMECRITICAL, 5L, 0UL );
#endif


    if((explode=WAV_LoadFN("explode.wav"))==NULL)
    {   puts("Error: Could not load EXPLODE.WAV!");
        return;
    }

    if((mecha=WAV_LoadFN("mecha.wav"))==NULL)
    {   puts("Error: Could not load MECHA.WAV!");
        return;
    }

    if((slash=WAV_LoadFN("slash.wav"))==NULL)
    {   puts("Error: Could not load SLASH.WAV!");
        return;
    }

    MikMod_EnableOutput();

    puts("Keys 1,2,3 - play EXPLOSION.WAV at left, middle, and right panning.");
    puts("Keys 4,5,6 - play MECHA.WAV at left, middle, and right panning.");
    puts("Keys 7,8,9 - play SLASH.WAV at left, middle, and right panning.");
    puts("  Press 'q' to quit.");

    while(!quit)
    {   if(kbhit())
        {   switch(getch())
            {   case 'Q':
                case 'q':  quit = 1; break;


                // Explosion Playback Triggers - 1, 2, 3

                case '1':
                    exp_voice = MikMod_PlaySample(explode,0,0);
                    Voice_SetPanning(exp_voice,PAN_LEFT);
                break;

                case '2':
                    exp_voice = MikMod_PlaySample(explode,0,0);
                    Voice_SetPanning(exp_voice,PAN_CENTER);
                break;

                case '3':
                    exp_voice = MikMod_PlaySample(explode,0,0);
                    Voice_SetPanning(exp_voice,PAN_RIGHT);
                break;


                // Mecha Playback Triggers - 4, 5, 6

                case '4':
                    mech_voice = MikMod_PlaySample(mecha,0,0);
                    Voice_SetPanning(mech_voice,PAN_LEFT);
                break;

                case '5':
                    mech_voice = MikMod_PlaySample(mecha,0,0);
                    Voice_SetPanning(mech_voice,PAN_CENTER);
                break;

                case '6':
                    mech_voice = MikMod_PlaySample(mecha,0,0);
                    Voice_SetPanning(mech_voice,PAN_RIGHT);
                break;


                // Slash Playback Triggers - 7, 8, 9

                case '7':
                    slash_voice = MikMod_PlaySample(slash,0,0);
                    Voice_SetPanning(slash_voice,PAN_LEFT);
                break;

                case '8':
                    slash_voice = MikMod_PlaySample(slash,0,0);
                    Voice_SetPanning(slash_voice,PAN_CENTER);
                break;

                case '9':
                    slash_voice = MikMod_PlaySample(slash,0,0);
                    Voice_SetPanning(slash_voice,PAN_RIGHT);
                break;
            }
        }

        delay(10);
        MD_Update();
    }

    MikMod_DisableOutput();
    WAV_Free(explode);
    WAV_Free(mecha);
    WAV_Free(slash);

    MikMod_Exit();
}


