

		;DebuggerQ	 = 1
		LoaderQ 	= 1

;

		EXTRN	_pm_info:FAR, _pm_init:FAR

;

		.386p
		LOCALS

		HMEMREQUIRED	= 2000000	; Bytes
		MAXHMEMPTRS	= 128		; Hmem ptrs possible at once
		DSK_BUFFERSIZE	= 16384 	; Bytes (Min 4096)
		STACKLEN	= 100h		; Paragraphs


;
;
		ASSUME cs:_Seg32,ds:_Seg32,es:_Seg32
_Seg32		SEGMENT PARA PUBLIC USE32

;

		INCLUDE music.i

;

SongPtr 	dd	0

;
; The 32bit mainexecution starts here!
;

CodeStart32	PROC	FAR

		lea	eax,text1
		call	PrintString

		call	GetCommInput
		or	eax,eax
		jz	@@got_name

		lea	eax,text_usage
		call	PrintString

		jmp	QuickExit
;-----------------------------------------------------------------------------

@@got_name:
		mov	MSC_SoundCard,Card_GUS
		;;mov	  MSC_GUSBasePort,220h	; Already done in GetCommInput
		call	MSC_InitMusic

		cmp	MSC_SoundCard,Card_GUS
		je	@@gus_used

		lea	eax,text_nogus
		call	PrintString
		jmp	QuickExit

;-----------------------------------------------------------------------------

@@gus_used:	lea	eax,text_usegus
		call	PrintString

		lea	eax,SongPtr
		mov	ebx,1500000
		call	GetHMem

		lea	eax,text_load
		call	PrintString

		mov	ax,LOAD_thesong
		mov	ebx,SongPtr
		call	DSK_LoadFile

		or	eax,eax
		jz	@@xm_loaded

		lea	eax,text_nofile
		call	PrintString

		jmp	QuickExit

;-----------------------------------------------------------------------------
@@xm_loaded:
		lea	eax,text_sinit
		call	PrintString

		mov	eax,SongPtr
		mov	MSC_SongPtr,eax
		call	MSC_InitSong


		mov	al,MSC_SongStatus
		cmp	al,0
		jz	@@song_ok

		cmp	al,1
		jne	@@not_unid
		lea	eax,text_notxm
		call	PrintString
		jmp	QuickExit
@@not_unid:	lea	eax,text_badxm
		call	PrintString
		jmp	QuickExit

;-----------------------------------------------------------------------------
@@song_ok:
		lea	eax,text_play
		call	PrintString


		mov	ax,1193180/625
		call	SetTimerPeriod

		call	MSC_StartSong


MainLoop:	call	WaitVBL

		; tra-la-laa

		in	al,60h
		cmp	al,1
		jne	MainLoop


;

QuickExit:
		call	MSC_StopSong

		ret
		ENDP

text1		db	80 dup ('')
		;db	 10,13
		db	' LousyPlayer (c) v1.12',10,13
		db	' Coded By the edge/CDA',10,10,13,36

text_usage	db	'USAGE:',10,13
		db	' lp <xm filename> [/xxx 3 hexdigit soundcard port]',10,13,36

text_load	db	'.Loading module',10,13,36
text_sinit	db	'.Initializing module',10,13,36

text_play	db	10,13,'Playing module. (Press ESC to exit)',10,13,36

text_usegus	db	'GUS detected.',10,13,36
text_nogus	db	'ERROR: GUS not detected.',10,13,36


text_nofile	db	'ERROR: File not found.',10,13,36
text_notxm	db	'ERROR: Unidentified songformat.',10,13,36
text_badxm	db	'ERROR: Corrupt XM or too old version.',10,13,36

;


GetCommInput	PROC	NEAR
		;	Out:
		;	 eax = 0   Got name
		;	     = 1   No name


		mov	MSC_GUSBasePort,220h

		mov	fs,SegPSP_PM

		cmp	BYTE PTR fs:[80h],0
		je	@@no_name

		lea	edi,DSK_SongFileName
		mov	ebx,81h

@@scan_loop:	mov	al,fs:[ebx]
		inc	ebx
		cmp	al,0dh
		je	@@end_name
		cmp	al,20h
		je	@@scan_loop
		stosb

@@read_loop:	mov	al,fs:[ebx]
		inc	ebx
		cmp	al,0dh
		je	@@end_name
		cmp	al,20h
		je	@@end_name
		stosb
		jmp	@@read_loop

@@end_name:	xor	al,al
		stosb

@@scan_loop2:	mov	al,fs:[ebx]
		inc	ebx
		cmp	al,0dh
		je	@@end_read
		cmp	al,20h
		je	@@scan_loop2

		cmp	al,'/'
		jne	@@end_read

		xor	edx,edx
		mov	ecx,3
@@dig_loop:	mov	al,fs:[ebx]
		inc	ebx
		cmp	al,0dh
		je	@@end_read
		cmp	al,20h
		je	@@end_read
		sal	edx,4
		cmp	al,'a'
		jb	@@not_small
		cmp	al,'f'
		ja	@@end_read
		sub	al,'a'-'A'
@@not_small:	cmp	al,'0'
		jb	@@end_read
		cmp	al,'F'
		ja	@@end_read
		cmp	al,'A'
		jb	@@numeric
		sub	al,'A'
		add	al,10
		jmp	@@n_numeric
@@numeric:	sub	al,'0'
@@n_numeric:	movzx	eax,al
		add	edx,eax
		loop	@@dig_loop

		mov	MSC_GUSBasePort,dx

@@end_read:
		xor	eax,eax
		ret
@@no_name:	mov	eax,1
		ret
		ENDP


;
; Timer interrupt handler! Please note that for easy of use the 18.2 ms
; periodical BIOS calls are omitted.



		ALIGN	16
TimerInt_PM	PROC	FAR
		pushad

		call	MSC_PlayTick

		mov	al,20h			; Send EOI
		out	20h,al

		popad
		iret
		ENDP

;

SetTimerPeriod	PROC	NEAR
		;	In:
		;	 ax = #ticks for period with clock 1.19318 MHz

		push	ebx
		mov	ebx,eax

		mov	al,36h
		out	43h,al
		mov	al,bl
		nop
		out	40h,al
		mov	al,bh
		nop
		out	40h,al

		pop	ebx
		ret
		ENDP


;


PrintString	PROC	NEAR
		;	In:
		;	 eax = PM ptr to string
		;
		;	OBS!! String must be located in DOS memory.

		pushad
		add	eax,BasePtr
		lea	edi,regs
		xor	ecx,ecx
		mov	ebx,21h
		mov	reg_ah,9
		push	eax
		and	eax,0fh
		mov	reg_dx,ax
		pop	eax
		shr	eax,4
		mov	reg_ds,ax
		mov	reg_ss,0
		mov	reg_sp,0
		mov	ax,300h
		int	31h
		popad
		ret
		ENDP


;
;

		ENDS

;
;
		ASSUME cs:_Seg32,ds:_Seg32,es:_Seg32
_Seg32		SEGMENT PARA PUBLIC USE32
		ALIGN	16

;

BeepAndHang	PROC	NEAR
		cli
		in	al,61h
		or	al,3
		out	61h,al
		jmp	$
		ENDP

;
		IFDEF	LoaderQ
DSK_LoadFile	PROC	NEAR
		;	In:
		;	 ax = Entry in FileList (0...65535)
		;	ebx = Ptr to destination
		;	Out:
		;	 eax = 0  Succes!
		;	     = 1  File not found


		mov	ebp,ebx
		movzx	eax,ax
		lea	eax,[eax+eax*2]
		lea	esi,DSK_FileList[eax*4]

		cmp	DSK_BigFileFlag,0
		jnz	@@bigfile

		mov	eax,8[esi]
		add	eax,OFFSET DSK_Base
		add	eax,BasePtr
		mov	edx,eax
		shr	eax,4
		and	dx,000fh
		jmp	@@open_file

@@bigfile:	mov	ax,_SegStart
		mov	dx,OFFSET exename

@@open_file:	mov	reg_ds,ax
		mov	reg_dx,dx
		mov	reg_ax,3d00h
		push	ds
		pop	es
		lea	edi,regs
		mov	ax,0300h
		mov	bx,21h
		xor	ecx,ecx
		int	31h

		pushfw
		push	reg_flags
		popfw
		jnc	@@file_exist
		popfw

		jmp	@@file_nfound

@@file_exist:	popfw

		mov	ax,reg_ax
		mov	DSK_FileHandle,ax

		mov	edx,[esi]
		or	edx,edx
		jz	@@no_seek

		mov	ax,4200h
		mov	bx,DSK_FileHandle
		mov	ecx,edx
		shr	ecx,16
		int	21h

@@no_seek:	mov	edi,ebp
		mov	edx,4[esi]
		mov	ebx,DSK_BUFFERSIZE

@@read1:	sub	edx,ebx
		jge	@@read2
		add	ebx,edx

@@read2:	pushad
		mov	reg_ax,3f00h
		mov	reg_cx,bx
		lea	eax,DSK_Buffer
		add	eax,BasePtr
		mov	ebx,eax
		and	ax,000fh
		shr	ebx,4
		mov	reg_ds,bx
		mov	reg_dx,ax
		mov	reg_ax,3f00h
		mov	ax,DSK_FileHandle
		mov	reg_bx,ax
		mov	ax,0300h
		mov	bx,21h
		xor	ecx,ecx
		lea	edi,regs
		push	ds
		pop	es
		int	31h
		popad

		mov	ecx,ebx
		shr	ecx,2
		lea	esi,DSK_Buffer
		rep	movsd
		mov	ecx,ebx
		and	ecx,3
		rep	movsb
		or	edx,edx
		jle	@@end_read
		mov	ax,reg_ax
		cmp	ax,bx
		jl	@@end_read
		jmp	@@read1

@@end_read:	mov	ax,3e00h
		mov	bx,DSK_FileHandle
		int	21h

		xor	eax,eax
		ret

@@file_nfound:	mov	eax,1
		ret
		ENDP
		ENDIF

;
; Internal memory hander.


GetHMem 	PROC	NEAR
		;	In:
		;	eax = address to memptr
		;	ebx = size in bytes

		pushad
		test	bl,0fh			; Force 16byte alignment
		jz	@@lenok
		and	bl,0f0h
		add	ebx,10h
@@lenok:	cmp	ebx,HMem_Free
		ja	@@error
		mov	edx,HMem_UsedPtrs
		cmp	edx,MAXHMEMPTRS
		jae	@@error
		mov	ecx,HMem_FreePtr
		mov	[eax],ecx
		sub	HMem_Free,ebx
		add	HMem_FreePtr,ebx
		lea	ecx,HMem_Ptrs
		mov	[ecx+edx*8],eax
		mov	4[ecx+edx*8],ebx
		inc	HMem_UsedPtrs
		popad
		ret
@@error:	jmp	BeepAndHang
		ENDP

;-----------------------------------------------------------------------------

FreeHMem	PROC	NEAR
		;	In:
		;	eax = address to memptr

		pushad
		lea	ebx,HMem_Ptrs
		mov	ebp,HMem_UsedPtrs
@@findptr:	mov	edx,[ebx]
		cmp	eax,edx
		je	@@ptrfnd
		lea	ebx,8[ebx]
		dec	ebp
		jg	@@findptr
		jmp	@@end
@@ptrfnd:	mov	edx,4[ebx]
		add	HMem_Free,edx
		sub	HMem_FreePtr,edx
		neg	edx
		cld
@@movelop:	dec	ebp
		jg	@@reorg
		dec	HMem_UsedPtrs
		jmp	@@end
@@reorg:	mov	eax,8[ebx]
		mov	[ebx],eax
		mov	esi,[eax]
		lea	edi,[esi+edx]
		mov	[eax],edi
		mov	ecx,12[ebx]
		mov	4[ebx],ecx
		mov	eax,ecx
		and	ecx,3
		rep	movsb
		mov	ecx,eax
		shr	ecx,2
		rep	movsd
		lea	ebx,8[ebx]
		jmp	@@movelop
@@end:		popad
		ret
		ENDP

;-----------------------------------------------------------------------------

ShrinkHMem	PROC	NEAR
		;	In:
		;	eax = address to memptr
		;	ebx = size in bytes

		pushad
		test	bl,0fh
		jz	@@sizeok
		and	bl,0f0h
		add	ebx,10h
@@sizeok:	push	ebx
		lea	ebx,HMem_Ptrs
		mov	ebp,HMem_UsedPtrs
@@findptr:	mov	edx,[ebx]
		cmp	eax,edx
		je	@@ptrfnd
		lea	ebx,8[ebx]
		dec	ebp
		jg	@@findptr
@@error:	jmp	BeepAndHang
@@ptrfnd:	pop	eax
		mov	edx,4[ebx]
		cmp	eax,edx
		ja	@@error
		je	@@end
		sub	edx,eax
		add	HMem_Free,edx
		sub	HMem_FreePtr,edx
		neg	edx
		cld
@@movelop:	dec	ebp
		jg	@@reorg
@@end:		popad
		ret
@@reorg:	mov	eax,8[ebx]
		mov	[ebx],eax
		mov	esi,[eax]
		lea	edi,[esi+edx]
		mov	[eax],edi
		mov	ecx,12[ebx]
		mov	4[ebx],ecx
		mov	eax,ecx
		and	ecx,3
		rep	movsb
		mov	ecx,eax
		shr	ecx,2
		rep	movsd
		lea	ebx,8[ebx]
		jmp	@@movelop
		ENDP

;


WaitVBL 	PROC	NEAR

		jmp	VSynch

		ENDP

;

WaitVBLs	PROC	NEAR
		;	In:
		;	 eax = # VBLs to wait


@@loop: 	dec	eax
		jl	@@end
		push	eax
		call	WaitVBL
		pop	eax
		jmp	@@loop
@@end:		ret
		ENDP

;

VSynch		PROC	NEAR

		mov	dx,03dah
@@vsynch1:	in	ax,dx
		test	ax,8
		jz	@@vsynch1
@@vsynch2:	in	ax,dx
		test	ax,8
		jnz	@@vsynch2
		ret
		ENDP

;

SetDescBase	PROC	NEAR
		;	In:
		;	 ax = selector
		;	ebx = baseaddress

		pushad
		add	ebx,BasePtr
		mov	dx,bx
		rol	ebx,16
		mov	cx,bx
		mov	bx,ax
		mov	ax,0007h
		int	31h
		popad
		ret
		ENDP

;-----------------------------------------------------------------------------

MakePMDataSeg	PROC	NEAR
		;	In:
		;	 eax = mem ptr
		;	Out:
		;	 ax = seg selector

		push	ebx
		push	ecx
		push	edx
		push	eax

		mov	ecx,1		 ; Allocate 1 descriptor
		xor	eax,eax
		int	31h
		jc	BeepAndHang

		push	eax
		mov	ebx,eax
		xor	edx,edx
		dec	edx
		mov	ecx,edx
		mov	eax,8
		int	31h
		pop	eax
		pop	ebx
		call	SetDescBase

		pop	edx
		pop	ecx
		pop	ebx
		ret
		ENDP

;



		ENDS

;
;


		ASSUME cs:_SegCode16
_SegCode16	SEGMENT PARA PUBLIC USE16 'CODE'


;
; Interrupt handling


C16SegData32_PM dw	0

		IFDEF	DebuggerQ
;
; Dummy interrupt

IntNoth_RM	PROC	FAR

		push	ax
		mov	al,20h
		out	20h,al
		nop
		out	0a0h,al
		pop	ax

		iret
		ENDP

;
; Debugger breakpoint interrupt

		ALIGN	16

Int3_PM 	PROC	FAR
		cli

		pushad
		push	ds
		push	es
		push	fs
		push	gs
		push	ss

		push	cs:C16SegData32_PM
		pop	ds

		mov	ax,0003
		int	10h
		mov	ax,0003
		int	10h

		lea	eax,@@msg1
		call	@@print_msg

		lea	eax,@@msg1b
		call	@@print_msg

		mov	eax,42+8[esp]
		call	@@print_number

		lea	eax,@@msg1c
		call	@@print_msg
		mov	eax,42+4[esp]
		call	@@print_number
		lea	eax,@@msgdbas
		call	@@print_msg
		mov	ax,6
		mov	ebx,42+4[esp]
		int	31h
		jnc	@@ok1a
		lea	eax,@@msgna
		call	@@print_msg
		jmp	@@ok1b
@@ok1a: 	mov	ax,cx
		shl	eax,16
		mov	ax,dx
		call	@@print_number
@@ok1b: 	lea	eax,@@msgdlim
		call	@@print_msg
		lsl	eax,42+4[esp]
		call	@@print_number

		lea	eax,@@msg1d
		call	@@print_msg
		movzx	eax,WORD PTR 8[esp]
		call	@@print_number
		lea	eax,@@msgdbas
		call	@@print_msg
		mov	ax,6
		movzx	ebx,WORD PTR 8[esp]
		int	31h
		jnc	@@ok2a
		lea	eax,@@msgna
		call	@@print_msg
		jmp	@@ok2b
@@ok2a: 	mov	ax,cx
		shl	eax,16
		mov	ax,dx
		call	@@print_number
@@ok2b: 	lea	eax,@@msgdlim
		call	@@print_msg
		movzx	ebx,WORD PTR 8[esp]
		lsl	eax,ebx
		call	@@print_number

		lea	eax,@@msg1e
		call	@@print_msg
		movzx	eax,WORD PTR 6[esp]
		call	@@print_number
		lea	eax,@@msgdbas
		call	@@print_msg
		mov	ax,6
		movzx	ebx,WORD PTR 6[esp]
		int	31h
		jnc	@@ok3a
		lea	eax,@@msgna
		call	@@print_msg
		jmp	@@ok3b
@@ok3a: 	mov	ax,cx
		shl	eax,16
		mov	ax,dx
		call	@@print_number
@@ok3b: 	lea	eax,@@msgdlim
		call	@@print_msg
		movzx	ebx,WORD PTR 6[esp]
		lsl	eax,ebx
		call	@@print_number

		lea	eax,@@msg1f
		call	@@print_msg
		movzx	eax,WORD PTR 4[esp]
		call	@@print_number
		lea	eax,@@msgdbas
		call	@@print_msg
		mov	ax,6
		movzx	ebx,WORD PTR 4[esp]
		int	31h
		jnc	@@ok4a
		lea	eax,@@msgna
		call	@@print_msg
		jmp	@@ok4b
@@ok4a: 	mov	ax,cx
		shl	eax,16
		mov	ax,dx
		call	@@print_number
@@ok4b: 	lea	eax,@@msgdlim
		call	@@print_msg
		movzx	ebx,WORD PTR 4[esp]
		lsl	eax,ebx
		call	@@print_number

		lea	eax,@@msg1g
		call	@@print_msg
		movzx	eax,WORD PTR 2[esp]
		call	@@print_number
		lea	eax,@@msgdbas
		call	@@print_msg
		mov	ax,6
		movzx	ebx,WORD PTR 2[esp]
		int	31h
		jnc	@@ok5a
		lea	eax,@@msgna
		call	@@print_msg
		jmp	@@ok5b
@@ok5a: 	mov	ax,cx
		shl	eax,16
		mov	ax,dx
		call	@@print_number
@@ok5b: 	lea	eax,@@msgdlim
		call	@@print_msg
		movzx	ebx,WORD PTR 2[esp]
		lsl	eax,ebx
		call	@@print_number

		lea	eax,@@msg1h
		call	@@print_msg
		movzx	eax,WORD PTR [esp]
		call	@@print_number
		lea	eax,@@msgdbas
		call	@@print_msg
		mov	ax,6
		movzx	ebx,WORD PTR [esp]
		int	31h
		jnc	@@ok6a
		lea	eax,@@msgna
		call	@@print_msg
		jmp	@@ok6b
@@ok6a: 	mov	ax,cx
		shl	eax,16
		mov	ax,dx
		call	@@print_number
@@ok6b: 	lea	eax,@@msgdlim
		call	@@print_msg
		movzx	ebx,WORD PTR [esp]
		lsl	eax,ebx
		call	@@print_number

		;lea	 esp,5*2[esp]

		lea	eax,@@msg1p
		call	@@print_msg
		mov	eax,10+28[esp]
		call	@@print_number

		lea	eax,@@msg2
		call	@@print_msg
		mov	eax,10+16[esp]
		call	@@print_number

		lea	eax,@@msg3
		call	@@print_msg
		mov	eax,10+24[esp]
		call	@@print_number

		lea	eax,@@msg4
		call	@@print_msg
		mov	eax,10+20[esp]
		call	@@print_number

		lea	eax,@@msg5
		call	@@print_msg
		mov	eax,10+4[esp]
		call	@@print_number

		lea	eax,@@msg6
		call	@@print_msg
		mov	eax,10[esp]
		call	@@print_number

		lea	eax,@@msg7
		call	@@print_msg
		mov	eax,10+8[esp]
		call	@@print_number

		lea	eax,@@msg8
		call	@@print_msg
		mov	eax,10+12[esp]
		call	@@print_number


		lea	eax,@@msg9
		call	@@print_msg
		mov	eax,42[esp]
		call	@@print_number

		lea	eax,@@msg10
		call	@@print_msg

@@key_loop:	in	al,60h
		cmp	al,10h
		je	@@quit
		cmp	al,2eh
		je	@@cont
		jmp	@@key_loop

@@cont: 	in	al,60h
		cmp	al,0aeh
		jne	@@cont
		pop	ss
		pop	gs
		pop	fs
		pop	es
		pop	ds
		popad
		iretd

@@quit: 	in	al,60h
		cmp	al,90h
		jne	@@quit
		mov	eax,42+8[esp]
		mov	esp,QuickExitEsp
		push	eax
		movzx	eax,Seg32Code_PM
		push	eax
		push	OFFSET QuickExit
		iretd

;-----------------------------------------------------------------------------

@@msg1		db	'the edge Exploration Service // BugBusters Incorperated',10,10,13,36
@@msg1b 	db	' EFLAGS = ',36
@@msg1c 	db	10,10,13,'  cs = ',36
@@msg1d 	db	10,13,'  ds = ',36
@@msg1e 	db	10,13,'  es = ',36
@@msg1f 	db	10,13,'  fs = ',36
@@msg1g 	db	10,13,'  gs = ',36
@@msg1h 	db	10,13,'  ss = ',36
@@msg1p 	db	10,10,13,' eax = ',36
@@msg2		db	10,13,' ebx = ',36
@@msg3		db	10,13,' ecx = ',36
@@msg4		db	10,13,' edx = ',36
@@msg5		db	10,13,' esi = ',36
@@msg6		db	10,13,' edi = ',36
@@msg7		db	10,13,' ebp = ',36
@@msg8		db	10,13,' esp = ',36
@@msg9		db	10,13,' eip = ',36
@@msg10 	db	10,10,13
		db	'(c)ontinue execution',10,13
		db	'(q)uit program',10,13,36
@@msgdbas	db	'   BaseA: ',36
@@msgdlim	db	'   Limit: ',36
@@msgna 	db	'N/A     ',36


@@print_msg	PROC	NEAR
		mov	ebx,eax
		and	ax,0fh
		shr	ebx,4
		add	bx,_SegCode16
		mov	reg_ah,9
		mov	reg_ds,bx
		mov	reg_dx,ax
		mov	reg_ss,0
		mov	reg_sp,0
		push	ds
		pop	es
		lea	edi,regs
		xor	ecx,ecx
		mov	bx,21h
		mov	ax,300h
		int	31h
		ret
		ENDP


@@print_number	PROC	NEAR
		lea	ebx,PrintNumberStr
		mov	cl,8
@@digitloop:	rol	eax,4
		mov	edx,eax
		and	edx,0fh
		add	dl,30h
		cmp	dl,3ah
		jl	@@no_char
		add	dl,7
@@no_char:	mov	[ebx],dl
		inc	ebx
		dec	cl
		jg	@@digitloop
		lea	eax,PrintNumberStr
		mov	ebx,eax
		and	ax,0fh
		shr	ebx,4
		add	bx,_Seg32
		mov	reg_ah,9
		mov	reg_ds,bx
		mov	reg_dx,ax
		mov	reg_ss,0
		mov	reg_sp,0
		push	ds
		pop	es
		lea	edi,regs
		xor	ecx,ecx
		mov	bx,21h
		mov	ax,300h
		int	31h
		ret
		ENDP
		ENDP
		ENDIF


;
; Keyboard interrupt

;-----------------------------------------------------------------------------

Int9_RM 	PROC	FAR
		call	Int9Code
		iret
		ENDP

;-----------------------------------------------------------------------------

Int9_PM 	PROC	FAR
		call	Int9Code
		iretd
		ENDP

;-----------------------------------------------------------------------------

Int9Code	PROC	NEAR
		push	ax
		push	dx

		in	al,60h
		mov	ah,al
		in	al,61h
		or	al,80h
		out	61h,al
		and	al,7Fh
		out	61h,al

		IFDEF	Comm
		mov	al,0
		mov	dx,3c8h
		out	dx,al
		inc	dx
		mov	al,30h
		out	dx,al
		nop
		out	dx,al
		nop
		out	dx,al
		ENDIF


		mov	al,20h		; Send EOI
		out	20h,al

		pop	dx
		pop	ax
		ret
		ENDP

;
		ENDS
;
;
		ASSUME	cs:_Seg32,ds:_Seg32,es:_Seg32
_Seg32		SEGMENT PARA PUBLIC USE32

;-----------------------------------------------------------------------------
		ALIGN	4


BasePtr 	dd	0
VideoPtr	dd	0
PSPAdr		dd	0

SegData16_PM	dw	0
Seg32Data_PM	dw	0
SegDataZero_PM	dw	0
SegCode16_PM	dw	0
Seg32Code_PM	dw	0
SegDataVar1_PM	dw	0
SegDataVar2_PM	dw	0
SegPSP_PM	dw	0


		ALIGN	4

Call		LABEL	FWORD
CallOffs	dd	0
CallSeg 	dw	0


QuickExitEsp		dd	0


OldIRQMask		dw	0

OldIntRMPtrs00_0F	dd	16 dup (0)
OldIntPMPtrs00_0F	dq	16 dup (0)
OldIntRMPtrs70_77	dd	8 dup (0)
OldIntPMPtrs70_77	dq	8 dup (0)

OldRowsNum		db	0

;PrintNumberStr 	 db	 8 dup (0),10,13,36
PrintNumberStr		db	8 dup (0),36

;-----------------------------------------------------------------------------

HMem_Handle	dd	0
HMem_BasePtr	dd	0
HMem_FreePtr	dd	0
HMem_Free	dd	0
HMem_UsedPtrs	dd	0
HMem_Ptrs	dd	MAXHMEMPTRS*2 dup (0)  ; dd	 Address to MemPtr
					       ; dd	 Size (bytes)

;-----------------------------------------------------------------------------
; Temporary variables
		ALIGN	4

tmpdd1		dd	0
tmpdd2		dd	0
tmpdd3		dd	0
tmpdd4		dd	0
tmpdw1		dw	0
tmpdw2		dw	0
tmpdw3		dw	0
tmpdw4		dw	0
tmpdb1		db	0
tmpdb2		db	0
tmpdb3		db	0
tmpdb4		db	0

;-----------------------------------------------------------------------------
; RM calling variables. Do not change order!

		ALIGN	4
regs		LABEL	DWORD
reg_edi 	LABEL	DWORD
reg_di		dw	0,0
reg_esi 	LABEL	DWORD
reg_si		dw	0,0
reg_ebp 	LABEl	DWORD
reg_bp		dw	0,0
		dd	0
reg_ebx 	LABEL	DWORD
reg_bx		LABEL	WORD
reg_bl		db	0
reg_bh		db	0,0,0
reg_edx 	LABEL	DWORD
reg_dx		LABEL	WORD
reg_dl		db	0
reg_dh		db	0,0,0
reg_ecx 	LABEL	DWORD
reg_cx		LABEL	WORD
reg_cl		db	0
reg_ch		db	0,0,0
reg_eax 	LABEL	DWORD
reg_ax		LABEL	WORD
reg_al		db	0
reg_ah		db	0,0,0
reg_flags	dw	0
reg_es		dw	0
reg_ds		dw	0
reg_fs		dw	0
reg_gs		dw	0
reg_ip		dw	0
reg_cs		dw	0
reg_sp		dw	0
reg_ss		dw	0

;-----------------------------------------------------------------------------

FramesNum		dd	0
Frame_LastVBLTick	dd	0

;-----------------------------------------------------------------------------

VBLPalPtr	dd	0


;-----------------------------------------------------------------------------

IFDEF LoaderQ
;

;-----------------------------------------------------------------------------
; Loader data
; This structure must be intact when creating bigfiles!
;
;	00	'EDGEFILE'
;	08	BigFileFlag (byte)	Not zero indicates bigfile.
;	09	FilesNum    (byte)	Number of files
;	10	FileList    (structure)
;
; FileList structure:
;
;	REPT	FilesNum
;	dd	0	Offset into file
;	dd	0	# bytes to load
;	dd	0	Ptr to filename string	- Ptr to DSK_Base
;	ENDM
;

		db	'EDGEFILE'      ; Loader identifier! Don't remove!
					; Used by outer programs!
DSK_Base	LABEL	DWORD
DSK_BigFileFlag db	0
DSK_FilesNum	db	1

DSK_FileList	LABEL	DWORD
		dd	0,1500000,DSK_SongFileName - DSK_Base

;-----------------------------------------------------------------------------

		LOAD_thesong = 0

DSK_SongFileName db	 80 dup (0)

DSK_FileHandle	dw	0


		ALIGN	16
DSK_Buffer	db	DSK_BUFFERSIZE dup (0)	; At least 4K!


;
ENDIF



		ENDS
;
;

		ASSUME	cs:_SegStart, ds:_Seg32
_SegStart	SEGMENT PARA PUBLIC USE16 'CODE'

pspstart	dw	0
exename 	db	130 dup (0)

end_msg 	db	10,13,36


errmsgtbl	dw	errmsg0,errmsg1,errmsg2,errmsg3
		dw	errmsg4,errmsg5,errmsg6,errmsg7


errmsg0 	db	'Not enough low memory!',13,10,36
errmsg1 	db	'80386 or better not detected!',13,10,36
errmsg2 	db	'System already in protected mode and no VCPI or DPMI found!',13,10,36
errmsg3 	db	'DPMI host is not 32bit!',13,10,36
errmsg4 	db	'Could not enable A20 gate!',13,10,36
errmsg5 	db	'Could not enter DPMI 32bit protected mode!',13,10,36
errmsg6 	db	'Could not allocate needed DPMI selectors!',13,10,36
errmsg7 	db	'Not enough continuous high memory!',13,10,36




;

CodeStart:
		mov	cs:pspstart,es
		push	es

		mov	ax,es:[2ch]		; get exename from env
		mov	es,ax
		xor	di,di
@@get_exename1: mov	ax,es:[di]
		lea	di,1[di]
		or	ax,ax
		jnz	@@get_exename1
		lea	di,3[di]
		lea	si,exename
@@get_exename2: mov	al,es:[di]
		mov	cs:[si],al
		inc	si
		inc	di
		or	al,al
		jnz	@@get_exename2

		mov	ax,_Seg32
		mov	ds,ax

		pop	es
		call	_pm_info
		jc	@@error

		xor	ax,ax
		mov	cx,ss
		add	cx,STACKLEN
		mov	dx,es:[2]
		sub	dx,cx
		cmp	dx,bx
		jb	@@error
		mov	es,cx
		call	_pm_init
		jc	@@error

		push	es

		mov	bx,ds		; Datasegment limit
		mov	bp,bx
		xor	dx,dx
		dec	dx
		mov	cx,dx
		mov	ax,8
		int	31h

		cli
		mov	ds,bp
		mov	es,bp
		mov	fs,bp
		mov	gs,bp
		mov	ss,bp
		mov	eax,_SegStack
		mov	ebx,_Seg32
		sub	eax,ebx
		shl	eax,4
		add	esp,eax

		mov	Seg32Data_PM,ds
		xor	eax,eax
		mov	ax,_Seg32
		shl	eax,4
		mov	BasePtr,eax
		mov	ebx,0a0000h
		sub	ebx,eax
		mov	VideoPtr,ebx

;-----------------------------------------------------------------------------
		pop	SegPSP_PM

		;movzx	 eax,cs:pspstart
		;shl	 eax,4
		;mov	 PSPAdr,eax

;-----------------------------------------------------------------------------

		mov	ax,1130h
		xor	bh,bh
		int	10h
		mov	OldRowsNum,dl


;-----------------------------------------------------------------------------
; DataZero descriptor

		mov	cx,1		; Allocate 1 descriptor
		xor	ax,ax
		int	31h
		mov	SegDataZero_PM,ax
		mov	bx,ax

		xor	dx,dx
		dec	dx
		mov	cx,dx
		mov	ax,8
		int	31h

;-----------------------------------------------------------------------------
; Code16 descriptor

		mov	cx,1		; Allocate 1 descriptor
		xor	ax,ax
		int	31h
		mov	SegCode16_PM,ax
		mov	bx,ax

		xor	dx,dx
		dec	dx
		mov	cx,dx
		mov	ax,8
		int	31h

		mov	edx,_SegCode16	; Base address = 32bit code segment
		shl	edx,4
		shld	ecx,edx,16
		mov	ax,7
		int	31h

		mov	ax,Seg32Data_PM ; Store DataSeg in Code16 segment
		push	ds
		mov	ds,bx
		ASSUME	ds:_SegCode16
		mov	C16SegData32_PM,ax
		pop	ds
		ASSUME	ds:_Seg32

		mov	ax,cs		; Set descriptor type to 16bit code
		lar	cx,ax		; at the current CPL
		mov	cl,ch
		mov	ch,080h
		mov	ax,9
		int	31h

;-----------------------------------------------------------------------------
; Code32 descriptor

		mov	cx,1		; Allocate 1 descriptor
		xor	ax,ax
		int	31h
		mov	Seg32Code_PM,ax
		mov	bx,ax

		xor	dx,dx
		dec	dx
		mov	cx,dx
		mov	ax,8
		int	31h

		mov	edx,_Seg32	; Base address = 32bit code segment
		shl	edx,4
		shld	ecx,edx,16
		mov	ax,7
		int	31h

		mov	ax,cs		; Set descriptor type to 32bit code
		lar	cx,ax		; at the current CPL
		mov	cl,ch
		mov	ch,0c0h
		mov	ax,9
		int	31h


;-----------------------------------------------------------------------------
; Allocate required high memory for internal memory handler

		mov	ax,0501h
		mov	ebx,HMEMREQUIRED+16*2
		mov	cx,bx
		shr	ebx,16
		int	31h
		jnc	@@mem_enough

		mov	ax,7
		jmp	@@errorPM

@@mem_enough:	lea	eax,HMem_Handle
		mov	[eax],di
		mov	2[eax],si
		shl	ebx,16
		and	bl,0f0h
		mov	bx,cx
		sub	ebx,BasePtr
		mov	HMem_BasePtr,ebx
		mov	HMem_FreePtr,ebx
		mov	HMem_Free,HMEMREQUIRED


;-----------------------------------------------------------------------------
; Save IRQ state
;
		in	al,0a1h
		mov	ah,al
		nop
		in	al,21h
		mov	OldIRQMask,ax

;-----------------------------------------------------------------------------
; Save interrupt vectors
;

		xor	edi,edi
@@saveintloop1: push	di

		mov	ax,0200h
		mov	bx,di
		int	31h
		sal	ecx,16
		mov	cx,dx
		mov	OldIntRMPtrs00_0F[edi*4],ecx

		add	al,4
		int	31h
		mov	DWORD PTR OldIntPMPtrs00_0F[edi*8],edx
		mov	WORD PTR OldIntPMPtrs00_0F+4[edi*8],cx

		pop	di
		inc	di
		cmp	di,16
		jl	@@saveintloop1


		mov	di,70h
@@saveintloop2: push	di

		mov	ax,0200h
		mov	bx,di
		int	31h
		sal	ecx,16
		mov	cx,dx
		mov	OldIntRMPtrs70_77[edi*4],ecx

		add	al,4
		int	31h
		mov	DWORD PTR OldIntPMPtrs70_77[edi*8],edx
		mov	WORD PTR OldIntPMPtrs70_77+4[edi*8],cx

		pop	di
		inc	di
		cmp	di,78h
		jl	@@saveintloop2


;-----------------------------------------------------------------------------
; Init int3 - debugger tool

		IFDEF	DebuggerQ
		mov	ax,0205h
		mov	bl,3
		mov	cx,SegCode16_PM
		mov	edx,OFFSET Int3_PM
		int	31h
		ENDIF

;-----------------------------------------------------------------------------
; Init int9 - keyboard interrupt

		mov	ax,0201h
		mov	bl,9
		mov	cx,_SegCode16
		mov	dx,OFFSET Int9_RM
		int	31h

		mov	ax,0205h
		mov	cx,SegCode16_PM
		mov	edx,OFFSET Int9_PM
		int	31h

;-----------------------------------------------------------------------------
; Init int8 - timer and vbl interrupt


		mov	bl,8
		mov	ax,0205h
		mov	cx,Seg32Code_PM
		mov	edx,OFFSET TimerInt_PM
		int	31h

;-----------------------------------------------------------------------------
; Store stackpointer for quick-exiting

		lea	eax,-8[esp]	; Adjust far call to 32bit maincode
		mov	QuickExitEsp,eax

;-----------------------------------------------------------------------------
; Call 32bit maincode

		cld
		mov	ax,Seg32Code_PM
		mov	CallSeg,ax
		lea	eax,CodeStart32
		mov	CallOffs,eax
		sti
		call	Call

		cli
;-----------------------------------------------------------------------------
; Restore IRQ state
;
		mov	ax,OldIRQMask
		out	21h,al
		mov	al,ah
		nop
		out	0a1h,al

;-----------------------------------------------------------------------------
; Restore interrupt vectors
;

		xor	edi,edi
@@restintloop1: push	di

		mov	ax,0201h
		mov	bx,di
		mov	ecx,OldIntRMPtrs00_0F[edi*4]
		mov	dx,cx
		shr	ecx,16
		int	31h

		add	al,4
		mov	cx,WORD PTR OldIntPMPtrs00_0F+4[edi*8]
		mov	edx,DWORD PTR OldIntPMPtrs00_0F[edi*8]
		int	31h

		pop	di
		inc	di
		cmp	di,16
		jl	@@restintloop1


		mov	di,70h
@@restintloop2: push	di

		mov	ax,0201h
		mov	bx,di
		mov	ecx,OldIntRMPtrs70_77[edi*4]
		mov	dx,cx
		shr	ecx,16
		int	31h

		add	al,4
		mov	cx,WORD PTR OldIntPMPtrs70_77+4[edi*8]
		mov	edx,DWORD PTR OldIntPMPtrs70_77[edi*8]
		int	31h

		pop	di
		inc	di
		cmp	di,78h
		jl	@@restintloop2


;-----------------------------------------------------------------------------
; Restore int8 - timer and vbl interrupt

		mov	al,36h
		out	43h,al
		xor	al,al
		out	40h,al
		nop
		out	40h,al

;-----------------------------------------------------------------------------
; Restore int9 - keyboard interrupt

		push	fs
		mov	ax,SegDataZero_PM
		mov	fs,ax
		mov	bx,417h
		mov	ax,fs:[bx]
		and	ax,0fcf0h
		mov	fs:[bx],ax
		pop	fs

;-----------------------------------------------------------------------------

		sti

;-----------------------------------------------------------------------------
; Free allocated high memory

		mov	ax,0502h
		lea	ebx,HMem_Handle
		mov	di,[ebx]
		mov	si,2[ebx]
		int	31h

;-----------------------------------------------------------------------------
; Set textmode and exit

		IFDEF Comm

		mov	ax,3
		int	10h

		cmp	OldRowsNum,49
		jne	@@setnot50
		xor	bx,bx
@@set50loop:	push	bx
		mov	ax,1102h
		pop	bx
		push	bx
		int	10h
		mov	ax,1112h
		pop	bx
		push	bx
		int	10h
		mov	ax,1123h
		xor	bx,bx
		mov	dl,50
		int	10h
		pop	bx
		inc	bx
		cmp	bx,1
		jle	SHORT @@set50loop
@@setnot50:
		ENDIF


		lea	edi,regs
		xor	cx,cx
		mov	bx,21h
		mov	reg_ah,9
		mov	reg_ds,_SegStart
		mov	si,ax
		add	si,ax
		mov	reg_dx,OFFSET end_msg
		mov	reg_ss,0
		mov	reg_sp,0
		mov	ax,300h
		int	31h



		mov	ah,4ch
		int	21h




;-----------------------------------------------------------------------------

@@errorPM:	lea	edi,regs
		xor	cx,cx
		mov	bx,21h
		mov	reg_ah,9
		mov	reg_ds,_SegStart
		mov	si,ax
		add	si,ax
		mov	ax,cs:errmsgtbl[si]
		mov	reg_dx,ax
		mov	reg_ss,0
		mov	reg_sp,0
		mov	ax,300h
		int	31h

		mov	ax,4cffh
		int	21h

@@error:	push	cs
		pop	ds

		mov	si,ax
		add	si,ax
		mov	dx,cs:errmsgtbl[si]
		mov	ah,9
		int	21h
		mov	ax,4cffh
		int	21h

		ENDS

;
;

_SegStack	SEGMENT PARA STACK USE16 'STACK'
		db	STACKLEN*10h dup(0)
		ENDS

;
;

		END	CodeStart





