; vscrollleft
; scrolls screen left by given amount
; input    : lines to scroll left
; on return: -
; call type: procedure vscrollleft(lines:word);
public vscrollleft
vscrollleft  proc far
             prefix
             mov scrolling,1
             mov cx,scx
             mov dx,sdx
             add cx,[bp+6]
             mov scx,cx
             mov ax,04f07h
             mov bx,00000h
             int 10h
             mov scrolling,0
             postfix
             ret
vscrollleft  endp


; vscrollright
; scrolls screen right by given amount
; input    : lines to scroll right
; on return: -
; call type: procedure vscrollright(lines:word);
public vscrollright
vscrollright  proc far
             prefix
             mov scrolling,1
             mov cx,scx
             mov dx,sdx
             sub cx,[bp+6]
             mov scx,cx
             mov ax,04f07h
             mov bx,00000h
             int 10h
             mov scrolling,0
             postfix
             ret
vscrollright endp

; vscrollup
; scrolls screen up by given amount
; input    : lines to scroll up
; on return: -
; call type: procedure vscrollup(lines:word);
public vscrollup
vscrollup    proc far
             prefix
             mov scrolling,1
             mov cx,scx
             mov dx,sdx
             add dx,[bp+6]
             mov sdx,dx
             mov ax,04f07h
             mov bx,0000h
             int 10h
             mov scrolling,0
             postfix
             ret 2
vscrollup    endp

; vscrolldown
; scrolls screen down by given amout
; input    : lines to scroll down
; on return: -
; call type: procedure vscrolldown(lines:word)
public vscrolldown
vscrolldown  proc far
             prefix
             mov scrolling,1
             mov cx,scx
             mov dx,sdx
             sub dx,[bp+6]
             mov sdx,dx
             mov ax,04f07h
             mov bx,0000h
             int 10h
             mov scrolling,0
             postfix
             ret 2
vscrolldown  endp
