Procedure ShowSaveFileInfo;
Begin
     vrestoremouse;
     SetFillStyle(SolidFill,Black);
     Bar(lx2-15*CharW,ly1+CharH*3,lx2-Charh*3,ly1+CharH*4);
     SetColor(Black+31);
     OutTextXY(lx2-15*CharW,ly1+CharH*3,SaveFile);
     vputmouse;
End;

Procedure SaveShowFiles;
Begin
     vrestoremouse;
     SetFillStyle(SolidFill,Black);
     Bar(lx1+CharW,ly1+CharH,lx1+CharW*20,ly2-CharH);
     For DummyByte := 0 to 17 do
     Begin
         FilePosition[DummyByte].Name := '';
         FilePosition[DummyByte].Typ  := 3;
     End;
     For DummyByte := Fptr to (Fptr + 17) do
     Begin
         if DummyByte = MaxFPtr then Break;
         if FileTree^[DummyByte].typ = _file then
         Begin
             if FileTree^[DummyByte].Status = _NOTSELECTED then
                SetColor(Black+31)
             else
                SetColor(Red+31);
         End
         else
         if FileTree^[DummyByte].typ = _dir then
             SetColor(Blue+31)
         else
         if FileTree^[DummyByte].typ = _drive then
             SetColor(Yellow+31);
         OutTextXY(lx1+CharW,ly1+CharH*(1+DummyByte-Fptr),FileTree^[DummyByte].Name);
         if FileTree^[DummyByte].typ = _file then
         Begin
              SetColor(Black+16);
              OutTextXY(lx1+CharW*14,ly1+CharH*(1+DummyByte-Fptr),S((FileTree^[DummyByte].Size div KB)+1,6,False));
         End;
         FilePosition[DummyByte-Fptr].Name := FileTree^[DummyByte].Name;
         FilePosition[DummyByte-Fptr].Typ  := FileTree^[DummyByte].Typ;
         FilePosition[DummyByte-Fptr].MainNo := DummyByte;
     End;
     vputmouse;
End;

Procedure SaveGetFileTree;
Var
    F :SearchRec;
    Fname :String[8];
    FExt  :String[3];
Begin
     Fptr := 0;
     MaxFptr := 0;
     {$I-}
     ChDir(CurrentPath);
     GetDir(0,CurrentPath);
     {$I+}
     For DummyByte := 0 to 25 do
     Begin
          if DriveAvailAble[DummyByte] then
          Begin
               FileTree^[MaxFptr].typ := _drive;
               FileTree^[MaxFptr].Name := Chr(65+DummyByte)+':';
               Inc(MaxFPtr);
          End;
     End;
     FindFirst('*.*',Directory,F);
     While DosError = 0 do
     Begin
          if F.Attr = Directory then
          Begin
               FileTree^[MaxFptr].typ  := _dir;
               FileTree^[MaxFptr].Name := F.Name;
               Inc(MaxFPtr);
          End;
          FindNext(F);
     End;
     FindFirst(FilePattern,0,F);
     While DosError = 0 do
     Begin
          if Pos('.',F.Name) = 0 then
             FileTree^[MaxFptr].Name := Left(F.Name,8)
          else
             FileTree^[MaxFptr].Name := Left(Left(F.Name,Pos('.',F.Name)-1),8)+'.'+
             Left(Right(F.Name,Length(F.Name)-Pos('.',F.Name)),3);
          if F.Attr = Directory then
             FileTree^[MaxFptr].typ  := _dir
          else
             FileTree^[MaxFptr].typ := _file;
          FileTree^[MaxFPtr].Size    := F.Size;
          FileTree^[MaxFPtr].Status  := _NOTSELECTED;
          Inc(MaxFptr);
          FindNext(F);
     End;
End;



Procedure SaveFptrTop;
Begin
     Fptr := 0;
End;

Procedure SaveFptrBot;
Begin
     if MaxFptr > 18 then
        Fptr := MaxFptr-18
     else
        Fptr := 0;
End;

Procedure SaveFptrMid;
Begin
     if MaxFptr > 18 then Fptr := (MaxFptr div 2);
End;

Procedure SaveFPtrUp;
Var
   LeftPressed : Boolean;
Begin
     if Fptr > 0 then
     Begin
          Dec(FPtr);
          SaveShowFiles;
     End;
     Delay(100);
     LeftPressed := LeftButton;
     While LeftPressed do
     Begin
          VertWait;
          if Fptr > 0 then
          Begin
               Dec(Fptr);
               SaveShowFiles;
          End;
          LeftPressed := LeftButton;
          VertWait;
     End;
End;

Procedure SaveFPtrDown;
Var
   LeftPressed: Boolean;
Begin
     if (Fptr+18) < MaxFptr then
     Begin
          Inc(FPtr);
          SaveShowFiles;
     End;
     Delay(100);
     LeftPressed := LeftButton;
     While LeftPressed do
     Begin
          VertWait;
          if (Fptr + 18) < MaxFPtr then
          Begin
               Inc(FPtr);
               SaveShowFiles;
          End;
          LeftPressed := LeftButton;
          VertWait;
     End;
End;

Procedure SaveSetFile;
Var
   OldOkay,
   OldCanceled : Boolean;
   _y : Integer;
Begin
     _y := ((MouseY+1 - ly1+CharH*9) div CharH) - 10;
     Case FilePosition[_y].typ of
          _file : Begin
                       SaveFile := FilePosition[_y].Name;

                       if OldSelected <> $FFFF then
                            FileTree^[OldSelected].Status := _NOTSELECTED;
                       FileTree^[FilePosition[_y].MainNo].Status := _SELECTED;
                       OldSelected := FilePosition[_y].MainNo;
                  End;
          _dir  : Begin
                       {$I-}
                       ChDir(FilePosition[_y].Name);
                       {$I+}
                       if IOResult = 0 then
                       Begin
                            GetDir(0,CurrentPath);
                            SaveGetFileTree;
                       End
                       else
                           OKBox('Having problems with '+FilePosition[_y].Name);
                  End;
          _drive: Begin
                       {$I-}
                       ChDir(FilePosition[_y].Name+'.');
                       {$I+}
                       if IOResult = 0 then
                       Begin
                            GetDir(0,CurrentPath);
                            SaveGetFileTree;
                       End
                       else
                       Begin
                           OldOkay := Okay;
                           OKBox('Having problem with drive '+FilePosition[_y].Name);
                           Okay := OldOkay;
                       End;
                  End;
     End;
End;

Procedure SaveSetFileName;
Var
   FF           : File;
   NewSaveFile  : String[12];
Begin
   NewSaveFile  := Upper(GetInput(lx2-CharW*15,ly1+CharH*3,12,False,Black,Black+31));
   if NewSaveFile <> '' then
   Begin
        SaveFile := NewSaveFile;
        if Pos('.',LoadFile) = 0 then
           SaveFile := Left(SaveFile,8)
        else
           SaveFile := Left(Left(SaveFile,Pos('.',SaveFile)-1),8)+'.'+
           Left(Right(SaveFile,Length(SaveFile)-Pos('.',SaveFile)),3);
        Okay := True;
   End;
End;

Procedure SaveProcess;
Var
   FF       :File;
   SaveIt   :Boolean;
   FileSize :LongInt;
   Page     :Word;
   DHandle  :Word;
   Percent  :Byte;
   LastPercent :Byte;
Begin
     SaveIt := TRUE;
     {$I-}
     Assign(FF,SaveFile);
     Reset(FF,1);
     {$I+}
     if IOResult = 0 then
     Begin
          Close(FF);
          SaveIt := AskBox(SaveFile+' already exists.Overwrite ?');
     End;
     if SaveIt then
     Begin
          Assign(FF,SaveFile);
          ReWrite(FF,1);
          FileBuffer := Ptr(EMSBASE,0);
          FileSize := SampleInfo[ActiveSample].Length;
          Page := 0;
          DHandle := SampleInfo[ActiveSample].EMSHandle;
          StatusBox('Saving...',0);
          Repeat
                Asm
                   push bp
                   push sp
                   mov ah,44h
                   mov al,0
                   mov bx,page
                   mov dx,Dhandle
                   push ax
                   push bx
                   push dx
                   int 67h          { Page 0 }
                   pop dx
                   pop bx
                   pop ax
                   inc al
                   inc bx
                   push ax
                   push bx
                   push dx
                   int 67h          { Page 1 }
                   pop dx
                   pop bx
                   pop ax
                   inc al
                   inc bx
                   push ax
                   push bx
                   push dx
                   int 67h          { Page 2 }
                   pop dx
                   pop bx
                   pop ax
                   inc al
                   inc bx
                   int 67h          { Page 3 }
                   pop sp
                   pop bp
               End;
               if FileSize > $FFFF then
               Begin
                   BlockWrite(FF,FileBuffer^,$FFFF);
                   FileSize := FileSize - $FFFF;
                   page := page + 4;
                   Percent := (SampleInfo[ActiveSample].Length - FileSize) div (SampleInfo[ActiveSample].Length div 100);
                   if Percent <> LastPercent then
                   Begin
                        StatusBox('',Percent);
                        LastPercent := Percent;
                   End;
               End
               else
               Begin
                   BlockWrite(FF,FileBuffer^,FileSize);
                   FileSize := 0;
               End;
          Until (FileSize = 0);
          Close(FF);
          if StatusBoxActive then StatusBox('',100);
     End;
End;

Procedure Save;
Var
   OldTreePtr : Byte;
Begin
     if ActiveSample = 0 then
          OKBox('No sample cell selected.')
     Else
     if SampleInfo[ActiveSample].Length = 0 then
          OKBox('Cell is empty.Nothing to save.')
     else
     Begin
          Bussy;
          PushMouse;
          LoadFile := '';
          lx1 := HALFMAXX-CharW*(20);
          lx2 := HALFMAXX+CharW*(20);
          ly1 := HALFMAXY-CharH*10;
          ly2 := HALFMAXY+CharH*10;
          SaveScreen(lx1,ly1,lx2,ly2);
          MsgBox(lx1,ly1,lx2,ly2,Blue,Blue+16);
          Inc(TreeLevel);
          OldTreePtr := TreePtr[TreeLevel];
          Okay := False;
          Canceled := False;
          RegisterWindow(lx1+CharW,ly1+CharH,lx1+CharW*14  ,ly2-CharH*1,SaveSetFile);
          RegisterWindow(lx2-CharW*15,ly1+CharH*3,lx2-CharW*3,ly1+CharH*4,SaveSetFileName);
          ButtonPrint(lx2-CharW*15,ly2-CharH*3,'SAVE',6,Black,Black,False,OK,NoNo);
          ButtonPrint(lx2-CharW*8 ,ly2-CharH*3,'CANCEL',6,Black,Black,False,CANCEL,NoNo);
          ButtonPrint(lx1+CharW*21,ly1+CharH*1 ,Chr(30)         , 1,Black+31,Blue,False,saveFptrUp      ,NoNo);
          ButtonPrint(lx1+CharW*21,ly2-CharH*3 ,Chr(31)         , 1,Black+31,Blue,False,saveFptrDown    ,NoNo);
          ButtonPrint(lx1+CharW*21,ly1+CharH*4 ,Chr(24)         , 1,Black+31,Blue,False,saveFPtrTop     ,NoNo);
          ButtonPrint(lx1+CharW*21,ly2-CharH*6 ,Chr(25)         , 1,Black+31,Blue,False,saveFPtrBot     ,NoNo);
          ButtonPrint(lx1+CharW*21,ly2-CharH*11,''             , 1,Black+31,Blue,False,saveFPtrMid     ,NoNo);
          SetColor(Black+16);
          OutTextXY(lx2-15*CharW,ly1+CharH*2,'Save as:');
          SaveFile := Strip(SampleInfo[ActiveSample].Name)+'.RAW';
          ShowSaveFileInfo;
          vrestoremouse;
          vsetmousecoor(lx2-CharW*5,ly2-CharH*2);
          SaveGetFileTree;
          SaveShowFiles;
          vrestoremouse;
          NotBussy;
          Repeat
                if ProcNo = 2 then
                Begin
                     Bussy;
{
                     MainProc[ProcNo];
                     MainProc[ProcNo]:=Nothing;
                     ProcNo := 1;
}
                     Kernel;
                     ShowSaveFileInfo;
                     vrestoremouse;
                     SaveShowFiles;
                     vrestoremouse;
                     NotBussy;
                End;
          Until (Okay) or (Canceled);
          Bussy;
          if Okay then SaveProcess;
          TreePtr[TreeLevel] := OldTreePtr;
          Dec(TreeLevel);
          RestoreScreen;
          PopMouse;
          NotBussy;
     End;
     ButtonPos := False;
End;

