Unit Rexx;

Interface

Function Center(Text:String;Len:Word;FillChar:Char):String;
Function Strip(s:string):string;
Function Upper(UpTo:String):String;
Function Left(LStr:String;Len:Byte):String;
Function Right(RStr:String;Len:Byte):String;

Implementation


Function Center(Text:String;Len:Word;FillChar:Char):String;
Var
   Ds   :String;
   i,j  :Byte;
Begin
     Ds := '';
     if Len <= Length(Text) then
     Begin
          For i := 1 to Len do
              Ds := Ds + Text[i];
     End
     else
     Begin
          j := (Len-Length(Text)) div 2;
          for i := 1 to j do
              ds := ds + FillChar;
          for i := j+1 to Length(Text)+j do
              ds := ds + Text[i-j];
          for i := 1 to j do
              ds := ds + FillChar;
     End;
     Center := Ds;
End;

function strip(s:string):string;
begin
  while s[length(s)]=' ' do dec(s[0]);
  while copy(s,1,1)=' ' do delete(s,1,1);
  strip:=s;
end;

Function Upper(UpTo:String):String;
Var
   a : Byte;
Begin
     For a := 1 to Length(UpTo) do
         UpTo[a] := UpCase(UpTo[a]);
     Upper := UpTo;
End;

Function Left(LStr:String;Len:Byte):String;
Begin
     if Len > Length(LStr) then
        LStr := Lstr + '        ';
     Delete(LStr,Len+1,Length(LStr)-Len);
     Left := LStr;
End;

Function Right(RStr:String;Len:Byte):String;
Begin
     While Len > Length(RStr) do
        RStr := ' '+RStr;
     Delete(RStr,1,Length(Rstr)-Len);
     Right := RStr;
End;
Begin
End.
