const
  SVGA320x200x256	= 0;	(* 320x200x256   Standard VGA *)
  SVGA640x400x256	= 1;	(* 640x400x256   Svga *)
  SVGA640x480x256	= 2;	(* 640x480x256   Svga *)
  SVGA800x600x256	= 3;	(* 800x600x256   Svga *)
  SVGA1024x768x256	= 4;	(* 1024x768x256  Svga *)
  SVGA640x350x256	= 5;	(* 640x350x256   Svga *)
  SVGA1280x1024x256	= 6;	(* 1280x1024x256 Svga *)

Procedure LeftPressed;Far;Forward;
Procedure RestoreMouse;Forward;
Procedure PutMouse;Forward;
Procedure Fill(X,Y,Color,BorderColor:Word);Forward;

Function Center(Text:String;Len:Word;FillChar:Char):String;
Var
   Ds   :String;
   i,j  :Byte;
Begin
     Ds := '';
     if Len <= Length(Text) then
     Begin
          For i := 1 to Len do
              Ds := Ds + Text[i];
     End
     else
     Begin
          j := (Len-Length(Text)) div 2;
          for i := 1 to j do
              ds := ds + FillChar;
          for i := j+1 to Length(Text)+j do
              ds := ds + Text[i-j];
          for i := 1 to j do
              ds := ds + FillChar;
     End;
     Center := Ds;
End;
Procedure MsgBox(X1,Y1,X2,Y2,Color,AreaColor:Word);
Var
   Y    :Word;
Begin
     RestoreMouse;
     For DummyByte := 0 to CharH div 2 do
     Begin
          SetColor(Color+DummyByte*8);
          RectAngle(X1+DummyByte,Y1+DummyByte,X2-DummyByte,Y2-DummyByte);

     End;
     SetColor(Red);
     RectAngle(X1+CharH div 2,Y1+CharH div 2,
               X2-CharH div 2,Y2-CharH div 2);
{
     Fill(x1+CharW,y1+CharH,AreaColor,Color+(DummyByte-1)*8);
     SetColor(AreaColor);
     For  Y := y1+CharH div 2 to y2-CharH div 2 do
     Begin
          MoveTo(x1+CharW div 2,Y);
          LineRel(X2-X1-CharW,0);
     End;
}
     SetFillStyle(SolidFill,AreaColor);
     Bar(x1+CharW div 2,y1+CharH div 2,X2-CharW div 2,y2-CharH div 2);
     PutMouse;
End;

Procedure RestoreMouse;
Begin
     if MouseActive then
     Begin
          if FirstCall = 1 then
             FirstCall := 0
          Else
             PutImage(MouseX,MouseY,Under^,COPYPUT);
     End;
End;
Procedure PutMouse;
Begin
     if MouseActive then
     Begin
          GetImage(MouseX,MouseY,MouseX+SIZE_X,MouseY+SIZE_Y,Under^);
          PutImage(MouseX,MouseY,ANDMASK^,ANDPUT);
          PutImage(MouseX,MouseY,XORMASK^,XORPUT);
     End;
End;
Procedure SaveScreen(X1,Y1,X2,Y2:Word);
Begin
     RestoreMouse;
     GetMem(ScrPtr[ScrNo],ImageSize(X1,Y1,X2,Y2));
     GetImage(X1,Y1,X2,Y2,ScrPtr[ScrNo]^);
     LocScr[ScrNo].X := X1;
     LocScr[ScrNo].Y := Y1;
     LocScr[ScrNo].Size := ImageSize(X1,Y1,X2,Y2);
     Inc(ScrNo);
     PutMouse;
End;

Procedure RestoreScreen;
Begin
     RestoreMouse;
     Dec(ScrNo);
     PutImage(LocScr[ScrNo].X,LocScr[ScrNo].Y,ScrPtr[ScrNo]^,COPYPUT);
     FreeMem(ScrPtr[ScrNo],LocScr[ScrNo].Size);
     PutMouse;
End;

Procedure SETPAL;
Var
   Pal          :Byte;
Begin
     For Pal := 0 to 255 do
     Begin
          port[$3c8] := Pal;
          port[$3c9] := Palette[Pal][0];
          port[$3c9] := Palette[Pal][1];
          port[$3c9] := Palette[Pal][2];
     End;
End;

Procedure PALInitialize;
Var
   Pal          :Byte;
Begin
     For Pal := 0 to 32 do
     Begin
          Palette[Pal][0] := Pal*2;
          Palette[Pal][1] := Pal*2;
          Palette[Pal][2] := Pal*2;

          Palette[Pal+32][0] := Pal*2;
          Palette[Pal+32][1] := 0;
          Palette[Pal+32][2] := 0;

          Palette[Pal+64][0] := 0;
          Palette[Pal+64][1] := Pal*2;
          Palette[Pal+64][2] := 0;

          Palette[Pal+96][0] := 0;
          Palette[Pal+96][1] := 0;
          Palette[Pal+96][2] := Pal*2;

          Palette[Pal+128][0] := Pal*2;
          Palette[Pal+128][1] := Pal*2;
          Palette[Pal+128][2] := 0;

          Palette[Pal+160][0] := 0;
          Palette[Pal+160][1] := Pal*2;
          Palette[Pal+160][2] := Pal*2;

          Palette[Pal+192][0] := Pal*2;
          Palette[Pal+192][1] := 0;
          Palette[Pal+192][2] := Pal*2;

          Palette[Pal+224][0] := 64-Pal*2;
          Palette[Pal+224][1] := Pal*2;
          Palette[Pal+224][2] := Pal*2;
     End;
End;

Procedure VGAInitialize(Mode:Integer);
Begin
     SetGraphMode(Mode);
     MAXX := GetMaxX;
     MAXY := GetMaxY;
     MAXCX := memw[$0040:$004A];
     PALInitialize;
     SETPal;
End;

function h2s(w: Word):String;
const
 hexChars: array [0..$F] of Char =
   '0123456789ABCDEF';
var
   s : String;
begin
 s := hexChars[Hi(w) shr 4] + hexChars[Hi(w) and $F] + hexChars[Lo(w) shr 4] + hexChars[Lo(w) and $F];
 h2s := s+'h';
end;


Procedure WaitAKey      ;Near; Assembler;
Asm
   xor ax,ax
   int 16h
End;
Procedure Int9Handler   ;Near; Assembler;
Asm
		iret
End;

Procedure Amplifier     ;Near; Assembler;
Asm
                ret
End;

Procedure SetNext4      ;Near; Assembler;
Asm
                ret
End;



Procedure Int8Handler   ;Near; Assembler;
Asm
                cli
                pushf
		pusha
                push    bp
                push    es
		push    ds
		in      al,60h                  { Read Keyboard    }
                cmp     al,1                    { Is it ESC ?      }
		jnz	@@noquit                { No, Goon playing }
		mov     _isend,true             { Set it to end    }
@@noquit:
		mov     bx,_smpoff              { bx = smpoff      }
		mov	es,_emsbase             { es = emsbase     }
		mov	al,es:[bx]              { al = emsbase:smpoff }
                cmp     _signed,true            { is sample signed    }
                jne     @@notsigned             { no }
		add	al,80h                  { yep,make it unsigned }
@@notsigned:
                cmp     _amplify,true           { will we amplify it }
                jne     @@noamplify             { no }
                call    amplifier               { yep,make it big ...}
@@noamplify:
                shr     al,2
                inc     al
                out     42h,al                  { play the note }
                cmp     _twin,true              { will we play this one again ? }
                jne     @@notwin                { no rate fast enough }
		xor	_cntr,1                 { yep,make counter 1 to remember }
                jnz     @@nexttime              { do not increment smpoff this time }
@@notwin:
		inc     bx                      { smpoff = smpoff + 1 }
                mov     _smpoff,bx              { smpoff = bx }
		jnz	@@l1                    { do we finished segment ? }
                call    setnext4                { yep, get next segment }
@@l1:
                dec     _smplenlo               { dec(smplenlo) }
                jnz     @@l2                    { smplenlo ?= 0 }
                cmp     _smplenhi,0             { yep, smplenhi ?= 0 }
                jz      @@smpend                { yep, finish playing }
                dec     _smplenhi               { dec(smplenhi) }
                jmp     @@l2                    { jmp routine end }
@@smpend:
                mov     _isend,true             { tell that it finished }
@@l2:
@@nexttime:
                mov     al,20h                  { clear keyboard buffer }
                out     20h,al

                pop     ds
                pop     es
                pop     bp
                popa
                popf
                sti
                iret
End;

Procedure DoSomething;Near;     Assembler;
Asm
        mov     ah,02h
        mov     dl,'.'
        int     21h
End;

Procedure StartPlaying  ;Near; Assembler;
Asm
                push    ss
                push    sp
                push    bp
                push    ds
                mov     ah,35h
                mov     al,8
                int     21h                     { get old int 8 vector }
                mov     _old8o,bx               { store it }
                mov     _old8s,es
                mov     ah,35h
                mov     al,9
                int     21h                     { get old int 9 vector }
                mov     _old9o,bx               { store it }
                mov     _old9s,es
                in      al,21h                  { get old 21h value }
                mov     _old21,al               { store it }
                cli
                mov     al,0ffh
                out     21h,al                  { disable all }
                sti
                push    ds
                push    cs
                pop     ds
                mov     ah,25h
                mov     al,8
                lea     dx,int8handler
                int     21h                     { set new int 8 vector }
                mov     ah,25h
                mov     al,9
                lea     dx,int9handler
                int     21h                     { set new int 9 vector }
                pop     ds
                mov     al,00110100b
                out     43h,al
                mov     ax,_magic
                mov     bl,_baserate
                div     bl
                cmp     _twin,true
                jnz     @@notwin
		shr	al,1
@@notwin:
                out     40h,al
                mov     al,0
                out     40h,al
                mov     al,90h
                out     43h,al
                in      al,61h
                or      al,3
                out     61h,al
                cli
                mov     al,01001010b            { enable only mouse end keyboard }
                out     21h,al
                sti
                xor     cx,cx
                mov     _isend,false
@@finish:
                cmp     _cntr,0
                jnz     @@nograph
{
                call    dosomething
}
@@nograph:
                cmp     _isend,true
                jnz     @@finish
                cli
                mov     al,0ffh
                out     21h,al
                sti
                in      al,61h
                and     al,0fch
                out     61h,al
                mov     al,34h
                out     43h,al
                mov     ax,0
                out     40h,al
                mov     al,ah
                out     40h,al
                mov     al,0b6h
                out     43h,al
                mov     ax,0533h
                out     42h,al
                mov     al,ah
                out     42h,al
                push    ds
                mov     ah,25h
                mov     al,8
                mov     dx,_old8o
                mov     ds,_old8s
                int     21h
                pop     ds
                push    ds
                mov     ah,25h
                mov     al,9
                mov     dx,_old9o
                mov     ds,_old9s
                int     21h
                pop     ds
                cli
                mov     al,_old21
                out     21h,al
                sti
                pop     ds
                pop     bp
                pop     sp
                pop     ss
End;

Function S(N:Integer):String;
Var
   SS   :String;
Begin
     Str(N,SS);
     S := SS;
End;

Function Convert(WStr:String):Word;
Var
   ret          :Word;
   pt           :Word;
Begin
     Ret := 0;
     pt  := 1;
     For DummyPtr := Length(Wstr) Downto 1 do
     Begin
          if Wstr[Dummyptr] = '1' then ret := ret + pt;
          pt := pt * 2;
     End;
     Convert := Ret;
End;



Procedure MouseMover;Far;
Begin
{
     if FirstCall = 1 then
          FirstCall := 0
     else
     PutImage(mousex,mousey,under^,COPYPUT);
}
     RestoreMouse;
     GetImage(newx,newy,newx+SIZE_X,newy+SIZE_Y,under^);
     mousex := newx;
     mousey := newy;
{
     PutImage(MouseX,MouseY,ANDMASK^,ANDPUT);
     PutImage(MouseX,MouseY,XORMASK^,XORPUT);
}
     PutMouse;
End;



Procedure RightPressed;Far;
Begin
     PutImage(MouseX,MouseY,Under^,COPYPUT);

     GetImage(MouseX,MouseY,MouseX+SIZE_X,MouseY+SIZE_Y,Under^);
     PutImage(MouseX,MouseY,XORMASK^,XORPUT);
End;
Procedure MouseHandler;Far;Assembler;
Asm
   pusha
   push es
   push ds
   push bp
   mov  bx,seg @DATA
   mov  ds,bx
   cmp  bussy,TRUE
   jz   @@quit
   test al,1
   jz  @@nomovement
   mov  newx,cx
   mov  newy,dx
   mov  ax,offset @@quit
   push cs
   push ax
   mov  ax,offset(MouseMover)
   push cs
   push ax
   retf
@@nomovement:
   test al,2
   jz  @@notleftpressed
   mov  ax,offset @@Quit
   push cs
   push ax
   mov  ax,offset(LeftPressed)
   push cs
   push ax
   retf
@@notleftpressed:
   test al,8
   jz  @@quit
   mov  ax,offset @@Quit
   push cs
   push ax
   mov  ax,offset(RightPressed)
   push cs
   push ax
   retf
@@Quit:
   pop  bp
   pop  ds
   pop  es
   popa
   retf
End;

Procedure MouseRange;
Var
   MouseMaxX,
   MouseMaxY    :Word;
Begin
     MouseMaxX := MAXX - SIZE_X;
     MouseMaxY := MAXY - SIZE_Y;
     Asm
        mov ax,8
        mov cx,0
        mov dx,MouseMaxY
        int 33h
        mov ax,7
        mov cx,0
        mov dx,MouseMaxX
        int 33h
     End;
End;

Procedure ArrowXOR;Assembler;
Asm
   db   000,000,000,000,000,000,000,000,000,000,000,000,000,000
   db   000,031,000,000,000,000,000,000,000,000,000,000,000,000
   db   000,031,031,000,000,000,000,000,000,000,000,000,000,000
   db   000,031,031,031,000,000,000,000,000,000,000,000,000,000
   db   000,031,031,031,031,000,000,000,000,000,000,000,000,000
   db   000,031,031,031,031,031,000,000,000,000,000,000,000,000
   db   000,031,031,031,031,031,031,000,000,000,000,000,000,000
   db   000,031,031,031,031,031,031,031,000,000,000,000,000,000
   db   000,031,031,031,031,031,031,031,031,000,000,000,000,000
   db   000,031,031,031,031,031,031,031,031,031,000,000,000,000
   db   000,031,031,031,031,031,031,031,031,031,031,000,000,000
   db   000,031,031,031,031,031,031,031,031,031,031,031,000,000
   db   000,031,031,031,031,031,031,031,031,031,031,031,031,000
   db   000,031,031,031,031,031,031,031,031,000,000,000,000,000
   db   000,031,031,031,031,031,031,031,031,000,000,000,000,000
   db   000,031,031,031,031,031,031,031,031,031,000,000,000,000
   db   000,031,031,031,000,000,031,031,031,031,000,000,000,000
   db   000,031,031,000,000,000,000,031,031,031,031,000,000,000
   db   000,031,000,000,000,000,000,031,031,031,031,000,000,000
   db   000,000,000,000,000,000,000,000,031,031,031,031,000,000
   db   000,000,000,000,000,000,000,000,031,031,031,031,000,000
   db   000,000,000,000,000,000,000,000,000,031,031,000,000,000
   db   000,000,000,000,000,000,000,000,000,000,000,000,000,000

End;

Procedure ArrowAND;Assembler;
Asm
   db   000,000,255,255,255,255,255,255,255,255,255,255,255,255
   db   000,000,000,255,255,255,255,255,255,255,255,255,255,255
   db   000,000,000,000,255,255,255,255,255,255,255,255,255,255
   db   000,000,000,000,000,255,255,255,255,255,255,255,255,255
   db   000,000,000,000,000,000,255,255,255,255,255,255,255,255
   db   000,000,000,000,000,000,000,255,255,255,255,255,255,255
   db   000,000,000,000,000,000,000,000,255,255,255,255,255,255
   db   000,000,000,000,000,000,000,000,000,255,255,255,255,255
   db   000,000,000,000,000,000,000,000,000,000,255,255,255,255
   db   000,000,000,000,000,000,000,000,000,000,000,255,255,255
   db   000,000,000,000,000,000,000,000,000,000,000,000,255,255
   db   000,000,000,000,000,000,000,000,000,000,000,000,000,255
   db   000,000,000,000,000,000,000,000,000,000,000,000,000,000
   db   000,000,000,000,000,000,000,000,000,000,000,000,000,000
   db   000,000,000,000,000,000,000,000,000,000,255,255,255,255
   db   000,000,000,000,000,000,000,000,000,000,000,255,255,255
   db   000,000,000,000,000,000,000,000,000,000,000,255,255,255
   db   000,000,000,000,255,255,000,000,000,000,000,000,255,255
   db   000,000,000,255,255,255,000,000,000,000,000,000,255,255
   db   000,000,255,255,255,255,255,000,000,000,000,000,000,255
   db   255,255,255,255,255,255,255,000,000,000,000,000,000,255
   db   255,255,255,255,255,255,255,255,000,000,000,000,255,255
   db   255,255,255,255,255,255,255,255,255,000,000,255,255,255
End;

Procedure MouseInitialize ;
Var
   pt           :Word;
   i,j          :Integer;
   DataPtr      :Pointer;
   Data         :^Byte;
Begin
     MouseSize := ImageSize(1,1,SIZE_X,SIZE_Y);
     GetMem(XORMASK,MouseSize);
     GetMem(ANDMASK,MouseSize);
     GetMem(Under,MouseSize);
     DataPtr := @ArrowXOR;
     Data := DataPtr;
     GetImage(1,1,SIZE_X,SIZE_Y,Under^);
     For i := 1 to SIZE_Y do
     Begin
          for j := 1 to SIZE_X do
          Begin
               if Data^ <> 0 then
                   PutPixel(j,i,Data^)
               else
                   PutPixel(j,i,Data^);
               Inc(Data);
          End;
     End;
     GetImage(1,1,SIZE_X,SIZE_Y,XORMASK^);
     DataPtr := @ArrowAND;
     Data := DataPtr;
     For i := 1 to SIZE_Y do
     Begin
          for j := 1 to SIZE_X do
          Begin
               PutPixel(j,i,Data^);
               Inc(Data);
          End;
     End;
     GetImage(1,1,SIZE_X,SIZE_Y,ANDMASK^);
     PutImage(1,1,under^,COPYPUT);
     asm
        xor ax,ax
        int 33h

        Mov ax,0fh
        mov cx,4
        mov dx,4
        int 33h
{
        mov ax,13h
        mov dx,10
        int 33h
        mov ax,1ah
        mov bx,16
        mov cx,16
        mov dx,16
        int 33h
}
        mov ax,0ch
        mov cx,1+2+8
        mov bx,seg(MouseHandler)
        mov es,bx
        mov dx,offset(MouseHandler)
        int 33h
     End;
     MouseRange;
     FirstCall := 1;
End;


Procedure ExitRoutine;
Begin
     asm
        mov     ax,0ch
        mov     cx,0
        mov     bx,seg(MouseHandler)
        mov     es,ax
        mov     dx,offset(MouseHandler)
        int     33h
     End;
     FreeMem(ButtonTree,SizeOf(ButtonTree^));
     FreeMem(XORMASK,MouseSize);
     FreeMem(ANDMASK,MouseSize);
     FreeMem(Under,MouseSize);

End;


Procedure Fill;
Begin
     SetFillStyle(SolidFill,Color);
     FloodFill(X,Y,BorderColor);
End;

{$F+}
Procedure  BoxPrint(X,Y:Integer;Text:String;TextColor,BoxColor:Word;Pressed:Boolean);
Var
   OldColor : word;
Begin
     RestoreMouse;
     OldColor := GetColor;
     If Not Pressed then
     Begin
          For DummyPtr := 0 to CharH do
          Begin
               DummyByte := BoxColor+DummyPtr*4;
               if (DummyByte = (DummyByte div 32)*32) and (DummyByte > BoxColor) then DummyByte := DummyByte - 2 ;
               SetColor(DummyByte);
               RectAngle(X+DummyPtr,Y+DummyPtr,X+Length(Text)*CharW+CharW-DummyPtr,Y+CharH+CharH-DummyPtr);
          End;
          SetColor(TextColor);
          OutTextXY((X+CharW div 2)+1,Y+CharH div 2,Text);
          SetColor(OldColor);
     End
     else
     Begin
          For DummyPtr := 0 to CharH do
          Begin
               DummyByte := BoxColor+DummyPtr*2;
               if (DummyByte = (DummyByte div 32) * 32) And (DummyByte > BoxColor) then DummyByte := DummyByte + 2;

               SetColor(DummyByte);
               RectAngle(X+DummyPtr,Y+DummyPtr,X+Length(Text)*CharW+CharW-DummyPtr,Y+CharH+CharH-DummyPtr);
          End;
          SetColor(TextColor);
          OutTextXY((X+CharW div 2)+1,Y+CharH div 2,Text);
          SetColor(OldColor);
     End;
     PutMouse;
End;
{$F-}

Procedure ButtonPrint(X,Y:Word;Text:String;TextColor,BoxColor:Word;Pressed:Boolean;Proc:ProcType;No:Integer);
Begin
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Xmin      := X;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Xmax      := X+(Length(Text)+2)*CharW;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Ymin      := Y;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Ymax      := Y+CharH*2;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Proc      := Proc;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Text      := Text;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].TextColor := TextColor;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].BoxColor  := BoxColor;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Pressed   := Pressed;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].No        := No;
     Inc(TreePtr[TreeLevel]);
     BoxPrint(X,Y,Text,TextColor,BoxColor,Pressed);

End;
