#include <string.h>
#include <conio.h>
#include <i86.h>
#include "imsrtns.h"

static void (__far __interrupt *tmOldTimer)();
static void (*tmTimerRoutine)();
static unsigned long tmTimerRate;
static unsigned long tmTicker;
static unsigned long tmIntCount;

static void far *getvect(unsigned char intno)
{
  REGS r;
  SREGS sr;
  r.h.ah=0x35;
  r.h.al=intno;
  sr.ds=sr.es=0;
  int386x(0x21, &r, &r, &sr);
  return MK_FP(sr.es, r.x.ebx);
}

static void setvect(unsigned char intno, void far *vect)
{
  REGS r;
  SREGS sr;
  r.h.ah=0x25;
  r.h.al=intno;
  r.x.edx=FP_OFF(vect);
  sr.ds=FP_SEG(vect);
  sr.es=0;
  int386x(0x21, &r, &r, &sr);
}


static void __interrupt tmTimerHandler()
{
  void loades();
#pragma aux loades = "push ds" "pop es"
  loades();

  outp(0x43,0x34);
  outp(0x40,tmTimerRate);
  outp(0x40,tmTimerRate>>8);

  tmTicker+=tmTimerRate;

  tmIntCount+=tmTimerRate;
  if (tmIntCount&0xFFFF0000)
  {
    tmIntCount&=0xFFFF;
    tmOldTimer();
  }

  outp(0x20,0x20);

  tmTimerRoutine();
}

char tmInit(void (*rout)(), unsigned long timerval)
{
  tmTimerRoutine=rout;
  tmIntCount=0;
  tmTicker=-timerval;
  tmTimerRate=timerval;

  tmOldTimer=(void (__far __interrupt *)())getvect(0x08);
  setvect(0x08, tmTimerHandler);

  outp(0x43, 0x34);
  outp(0x40, tmTimerRate);
  outp(0x40, (tmTimerRate>>8));

  return 1;
}

void tmSetNewRate(unsigned long val)
{
  tmTimerRate=val;
  outp(0x43,0x34);
  outp(0x40,tmTimerRate);
  outp(0x40,tmTimerRate>>8);
}

long tmGetTicker()
{
  return tmTicker;
}

void tmSetTicker(long t)
{
  tmTicker+=t-tmGetTicker();
}

long tmGetTimer()
{
  unsigned short f=_disableint();

  unsigned long tm=tmTimerRate+tmTicker;
  outp(0x43,0);
  tm-=inp(0x40);
  tm-=inp(0x40)<<8;

  _restoreint(f);

  return umuldiv(tm, 65536, 1193046);
}

void tmClose()
{
  setvect(0x08, tmOldTimer);
  outp(0x43, 0x34);
  outp(0x40, 0x00);
  outp(0x40, 0x00);
}
