#include <conio.h>
#include "timer.h"

static char __far *stack;
static const unsigned long stacksize=8192;
static void __far *oldssesp;
static void (*pollproc)();

void stackcall(void *);
#pragma aux stackcall parm [eax] = \
  "mov word ptr oldssesp+4,ss" \
  "mov dword ptr oldssesp+0,esp" \
  "lss esp,stack" \
  "sti" \
  "call eax" \
  "cli" \
  "lss esp,oldssesp"

static void stackirq()
{
  static char inirq=0;
  if (inirq)
    return;
  inirq++;
  stackcall(pollproc);
  inirq--;
}

int pollInit(void (*proc)())
{
  pollproc=proc;
  stack=new char [stacksize];
  if (!stack)
    return 0;
  stack+=stacksize;
  tmInit(stackirq, 17100);
  return 1;
}

void pollClose()
{
  tmClose();
  delete (char near *)(stack-stacksize);
}
