/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

import herman.midi.*;
import herman.midiplayer.*;

public class testMidiPlayer
{
  public static void main(String[] argv)
    throws Exception
  {
    // init the MIDI system
    Midi.init();
    
    // get the MIDI device to use
    int choice;
    while(true)
    {
      System.out.println("Choose a MIDI output device:\n");
      for(int i=0; i< Midi.outDevices.length; i++)
	System.out.println("" + i + "\t" + Midi.outDevices[i].getName());
      choice = (System.in.read() - '0');
      if ((choice >= 0) && (choice < Midi.outDevices.length))
	break;
    }
    
    // get the desired MIDI output device
    MidiOut midiOut = new MidiOut(Midi.outDevices[choice]);

    // init the MIDI player
    MidiPlayer.init(midiOut);	
    
    // sequence the notes
    for(int i=0; i< 100; i++)
      for(int j=0; j < 7; j++)
      {
	MidiPlayer.send(new MidiNoteOnEvent(0, 40+(j*10), 60, 0, 
					    1000 + (i*1400)+(j*200)));
	MidiPlayer.send(new MidiNoteOffEvent(0, 40+(j*10), 60, 0, 
					     1000+ (i*1400)+(j*200)+200));
      }

    // we have finished
    System.out.println("I am here");
  }
}

      

