/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

import herman.midi.*;


public class testMidi
{
  public static void main(String[] argv)
    throws Exception
  {
    // init the MIDI system
    Midi.init();
    
    // get the MIDI device to use
    int choice;
    while(true)
    {
      System.out.println("Choose a MIDI output device:\n");
      for(int i=0; i< Midi.outDevices.length; i++)
	System.out.println("" + i + "\t" + Midi.outDevices[i].getName());
      choice = (System.in.read() - '0');
      if ((choice >= 0) && (choice < Midi.outDevices.length))
	break;
    }
    
    // get the desired MIDI output device
    MidiOut midiOut = new MidiOut(Midi.outDevices[choice]);

    // play a note
    int note = 0;
    while(true)
    {
      midiOut.noteOn(1, note, 60, 0);
      choice = System.in.read();
      midiOut.noteOff(1, note++, 60, 0);
      
      if ((choice == 'X') || (choice == 'x'))
	break;
    }
      
    Midi.shutdown();
  }
}

      
