/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

import herman.midi.*;
import herman.midiplayer.*;
import herman.misc.*;
import herman.gui.*;

public class hermmain
{

  public static void main(String[] argv)
    throws Exception
  {
    // init the MIDI system
    Midi.init();

    // make up list of devices
    Configuration.midiDevices = new String[Midi.outDevices.length];
    for(int i=0; i< Midi.outDevices.length; i++)
      Configuration.midiDevices[i] = Midi.outDevices[i].getName();
    
    // get user's selection
    Gui.showConfig();
    int choice = Gui.deviceSelected;
    
    // get the desired MIDI output device
    MidiOut midiOut = new MidiOut(Midi.outDevices[choice]);

    // setup the MIDI device properly
    midiOut.modeMessage(MidiOut.MODE_OMNIMODEON);
    midiOut.modeMessage(MidiOut.MODE_POLYPHONICMODE);

    // init everything else
    herman.gui.Gui.init(midiOut);
    herman.pitch.io.PitchStartUp.initialize();
    herman.form.PhraseForm.initialize();
    herman.form.SentenceForm.initialize();
    herman.rhythm.Rhythm.init();
    herman.mapper.Mapper.initialize();
    herman.eventprocess.EventProcess.init();
  }
}

      

