/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.rhythm.transforms;
import herman.rhythm.*;
import herman.elements.*;
import herman.properties.*;
import java.util.*;

public class VelocityChangeTransform extends RhythmTransform
{
  private double factor;

  public VelocityChangeTransform(double factor)
  {
    this.factor = factor;
  }


  public void apply(Phrase p)
  {
    Enumeration melEnum;
    Enumeration percEnum;
    Enumeration accompEnum;
    
    melEnum = (Enumeration) p.partMelEventGroup.getElements();
    accompEnum = (Enumeration) p.partChord.getElements();
    percEnum = (Enumeration) p.partPercEvent.getElements();

      
    // adjust melody 
    while(melEnum.hasMoreElements())
    {
      EventGroup e = (EventGroup) melEnum.nextElement();
      Enumeration melGroupEnum = (Enumeration) e.partMelEvent.getElements();
      
      while(melGroupEnum.hasMoreElements())
      {
	Event evt = (Event) melGroupEnum.nextElement();
	evt.velocity = (int) Math.round((double) evt.velocity * factor);
      }
    }
    
    // adjust accomp
    while(accompEnum.hasMoreElements())
    {
      Chord e = (Chord) accompEnum.nextElement();
      Enumeration accompGroupEnum = (Enumeration) e.partAccompEvent.getElements();
      
      while(accompGroupEnum.hasMoreElements())
      {
	Event evt = (Event) accompGroupEnum.nextElement();
	evt.velocity = (int) Math.round((double) evt.velocity * factor);
      }
    }
  }
}
