/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.rhythm.transforms;
import herman.rhythm.*;
import herman.elements.*;
import herman.properties.*;
import java.util.*;

public class TempoChangeTransform extends RhythmTransform
{
  private double factor;

  public TempoChangeTransform(double factor)
  {
    this.factor = factor;
  }


  public void apply(Phrase p)
  {
    Enumeration melEnum;
    Enumeration percEnum;
    Enumeration accompEnum;
    
    melEnum = (Enumeration) p.partMelEventGroup.getElements();
    accompEnum = (Enumeration) p.partChord.getElements();
    percEnum = (Enumeration) p.partPercEvent.getElements();

      
    // adjust melody 
    long totalTime = 0;
    while(melEnum.hasMoreElements())
    {
      EventGroup e = (EventGroup) melEnum.nextElement();
      Enumeration melGroupEnum = (Enumeration) e.partMelEvent.getElements();
      
      long time = 0;
      while(melGroupEnum.hasMoreElements())
      {
	MusicElement evt = (Event) melGroupEnum.nextElement();
	evt.duration = Math.round((double) evt.duration * factor);
	evt.startTime = totalTime + time;
	time += evt.duration;
      }
      
      e.duration = time;
      e.startTime = totalTime;
      totalTime += time;
    }

    // update phrase length
    p.duration = totalTime;
    
    // adjust percussion 
    totalTime = 0;
    while(accompEnum.hasMoreElements())
    {
      Chord e = (Chord) accompEnum.nextElement();
      Enumeration accompGroupEnum = (Enumeration) e.partAccompEvent.getElements();
      
      long time =0;
      while(accompGroupEnum.hasMoreElements())
      {
	MusicElement evt = (Event) accompGroupEnum.nextElement();
	evt.duration = Math.round((double) evt.duration * factor);
	evt.startTime = totalTime + time;
	time += evt.duration;
      }
      
      e.duration = time;
      e.startTime = totalTime;
      totalTime += time;
    }
  }
}
