/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.rhythm.rules;
import herman.rhythm.*;
import herman.misc.*;
import herman.elements.*;

public class ReverseFootMiddle extends RhythmRule
{


  public ReverseFootMiddle()
  {
    rangeStart=70;
    rangeEnd=99;
    ruleType=Foot.RULE_MIDDLE;
  }


  public double apply(ItemList feet, RhythmStuff params, double nextTimeBeats)
  {
    double beatCounter=0;

    switch(Foot.lastFootUsed)
    {
    case Foot.AMBIBRACH:
      // U - U => add iamb U -
      beatCounter = Foot.addIamb(feet, params, nextTimeBeats);
      break;

    case Foot.ANAPEST:
      // U U - => add dactyl - U U
      beatCounter = Foot.addDactyl(feet, params, nextTimeBeats);
      break;

    case Foot.DACTYL:
      //  - U U => add anapest U U -
      beatCounter = Foot.addAnapest(feet, params, nextTimeBeats);
      break;

    case Foot.IAMB:
      // U - => add trochee - U
      beatCounter = Foot.addTrochee(feet, params, nextTimeBeats);
      break;

    case Foot.TROCHEE:
      // - U => add iamb  U -
      beatCounter = Foot.addIamb(feet, params, nextTimeBeats);
      break;      
    }

    return(beatCounter);
  }
}


