/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.rhythm.rules;
import herman.rhythm.*;
import herman.misc.*;
import herman.elements.*;

public class ReverseFootEnd extends RhythmRule
{


  public ReverseFootEnd()
  {
    rangeStart=70;
    rangeEnd=99;
    ruleType=Foot.RULE_END;
  }


  public double apply(ItemList feet, RhythmStuff params, double nextTimeBeats)
  {
    double beatCounter=0;

    switch(Foot.lastFootUsed)
    {
    case Foot.ANAPEST:
      // U U - => add dactyl - U U
      beatCounter = Foot.addDactyl(feet, params, nextTimeBeats);
      break;

    case Foot.IAMB:
      // U - => add trochee - U
      beatCounter = Foot.addTrochee(feet, params, nextTimeBeats);
      break;

    // these three would result in an upbeat at the end - we don't want this
    case Foot.AMBIBRACH:
    case Foot.DACTYL:
    case Foot.TROCHEE:
      // X => add trochee  - U
      beatCounter = Foot.addTrochee(feet, params, nextTimeBeats);
      break;      
    }

    return(beatCounter);
  }
}


