/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.rhythm;
import herman.misc.*;
import herman.elements.*;

public class RhythmThread extends Thread
{

  public void run()
  {
    Phrase phrase;

    // this runs forever (well, sort of, ish, like)
    while(true)
    {
      // get the next event from the queue
      phrase = (Phrase) Rhythm.phraseInputQueue.next();

      // eek! we've no queue elements left, so suspend ourselves until
      // we're informed we have some
      if (phrase == null)
      {
	Rhythm.rhythmThreadSuspended = true;
	this.suspend();
	continue;
      }
     
      // OK, check if we have note data present. If not, generate some
      // (just check the melodic event list; assume if this is empty, then
      //  so are the others)
      if (phrase.partMelEventGroup.size() == 0)
      {
	try
	{
	  Generate.operate(phrase, phrase.rhythmStuff);
	}
	catch (CloneNotSupportedException e)
	{
	  throw new FatalError(e.toString());
	}
      }
      else
      {
	System.out.println("repeating phrase");
	
	System.out.println(phrase.partMelEventGroup.size());
      }

      // Perform any transformations we were asked to do...
      Transform.operate(phrase);

      // add the thing into the rhythm output queue	
      Rhythm.addProcessedPhrase(phrase);
    }
  }
}

