/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.rhythm;
import java.util.*;


/**
 * Class to hold per-phrase configuration parameters for the Rhythm module.
 * Has both generative and  transformative information
 */
public class RhythmStuff implements Cloneable
{
  /**
   * The transformations to apply
   */
  public Vector transformations = new Vector();

  /**
   * Use nothing to distinguish accented notes from unaccented 
   */
  public final static int ACCENT_NONE =0;
  
  /**
   * Use velocity to distinguish accented notes from unaccented
   */
  public final static int ACCENT_VELOCITY =1;
  
  /**
   * Use length to distingush accented notes from unaccented
   */
  public final static int ACCENT_LENGTH =2;
  
  /**
   * USe velocity AND length to distingush accented notes from unaccented
   */
  public final static int ACCENT_VELOCITYLENGTH =3;



  /** 
   * Accented note length, in beats (can have fractions of beats)
   */
  public double accentedNoteLengthBeats = 1.5;

  /** 
   * Unaccented note length, in beats (can have fractions of beats)
   */
  public double unAccentedNoteLengthBeats = 1;

  /**
   * Accented note velocity.
   */
  public int accentedNoteVelocity = 50;

  /**
   * Unaccented note velocity.
   */
  public int unAccentedNoteVelocity = 40;  
  
  /**
   * Indicates how to accent notes. Can be ACCENT_NONE, ACCENT_VELOCITY or
   * ACCENT_LENGTH
   */
  public int accentingType = ACCENT_VELOCITYLENGTH;
    
  /**
   * Indicates the desired level of tension
   * (range = 0 to 99, 0 = not tense)
   */
  public int tensionLevel = 0;
  
  /**
   * Number of beats making up a phrase
   */
  public int phraseLengthBeats = 5*4;

  /**
   * Number of beats making up a motif
   */
  public int motifLengthBeats = 5;

  /**
   * Length of a beat in milliseconds
   */
  public int beatLengthMillis = 400;



  /**
   * Add a transformation to be applied
   *
   * @param rt An instance of the transformation to apply
   */
  public void addTransform(RhythmTransform rt)
  {
    transformations.addElement((Object) rt);
  }

    
  /**
   * Get an enumeration of all the transformations to apply
   */
  public Enumeration getTransforms()
  {
    return(transformations.elements());
  }


  /**
   * Wipe all the transfromations from this
   */
  public void flushTransforms()
  {
    transformations.removeAllElements();
  }


  public Object clone()
    throws CloneNotSupportedException
  {
    RhythmStuff newStuff = (RhythmStuff) super.clone();
    newStuff.transformations = (Vector) transformations.clone();

    return((Object) newStuff);
  }

}
