/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.rhythm;
import herman.misc.*;
import herman.elements.*;
import java.util.*;

public class Rhythm
{
  private Rhythm(){}


  protected static Queue phraseInputQueue = new Queue();

  protected static boolean rhythmThreadSuspended = false;
  protected static RhythmThread rhythmThread;
  protected static Random randGenerator = new Random();

  private static Queue processedPhrases = new Queue();
  
  private static Phrase curPhrase = null;
  private static Enumeration melodyEnum = null;
  private static Enumeration accompEnum = null;
  private static Enumeration percEnum = null;

  private static Enumeration melodyGroupEnum = null;
  private static Enumeration accompGroupEnum = null;
  private static Enumeration percGroupEnum = null;

  protected static boolean gettingNextPhrase = false;


  public static void init()
  {
    Foot.init();
    rhythmThread = new RhythmThread();
    rhythmThread.start();
  }


  public static void add(Phrase phrase)
  {
    phraseInputQueue.add((Object) phrase);
    if (rhythmThreadSuspended)
      rhythmThread.resume();
  }





  public static boolean getNextFewEvents()
  {
    Vector melList = new Vector();
    Vector accompList = new Vector();
    Vector percList = new Vector();
    int melTime =0;
    int accompTime =0;
    int percTime =0;
    MusicElement tmp;


    // check we've actually got some data to go on!
    // if not, then ask for some
    if (((melodyEnum == null) || (!melodyEnum.hasMoreElements())) &&
	((accompEnum == null) || (!accompEnum.hasMoreElements())) &&
	((percEnum == null) || (!percEnum.hasMoreElements())) &&
	((melodyGroupEnum == null) || (!melodyGroupEnum.hasMoreElements())) &&
	((accompGroupEnum == null) || (!accompGroupEnum.hasMoreElements())) &&
	((percGroupEnum == null) || (!percGroupEnum.hasMoreElements())))
    {
      // request a new phrase
      if (!gettingNextPhrase)
	if ((curPhrase = (Phrase) processedPhrases.next()) == null)
	{
	  gettingNextPhrase = true;
	  herman.form.PhraseForm.getNewPhrase();
	}

      // there's no data to get. Indicate failure this time
      return(false);
    }

    // OK, we were successful
    gettingNextPhrase = false;
      
    boolean update;
    while(true)
    {
      update = false;

      // update the enumerations of actual Events for melody
      if ((melodyGroupEnum == null) || (!melodyGroupEnum.hasMoreElements()))
	if (melodyEnum.hasMoreElements())
	{
	  EventGroup e = (EventGroup) melodyEnum.nextElement();
	  herman.form.Contour.melodyInQueue.push((Object) e);
	  melodyGroupEnum = (Enumeration) e.partMelEvent.getElements();
	}

      // update the enumerations of actual Events for accomp
      if ((accompGroupEnum == null) || (!accompGroupEnum.hasMoreElements()))
	if (accompEnum.hasMoreElements())
	{
	  Chord e = (Chord) accompEnum.nextElement();
	  herman.form.Contour.accompInQueue.push((Object) e);
	  accompGroupEnum = (Enumeration) e.partAccompEvent.getElements();
	}

      // update the enumerations of actual Events for perc
      if ((percGroupEnum == null) || (!percGroupEnum.hasMoreElements()))
	if (percEnum.hasMoreElements())
	{
	  // dunno what should happen here
	  // percGroupEnum = percEnum.nextElement();
	}

      // add in the next melody event, if appropriate
      if ((melodyGroupEnum != null) &&
	  (melodyGroupEnum.hasMoreElements()) && 
	  (melTime < Configuration.deltaTime))
      {
	update=true;
	tmp = (MusicElement) melodyGroupEnum.nextElement();
	melTime += tmp.duration;

	herman.form.Contour.melodyInQueue.push((Object) tmp);
      }

      // add in the next accompaniment event, if appropriate
      if ((accompGroupEnum != null) &&
	  (accompGroupEnum.hasMoreElements()) &&
	  (accompTime < Configuration.deltaTime))
      {
	update=true;
	tmp = (MusicElement) accompGroupEnum.nextElement();
	accompTime += tmp.duration;
	herman.form.Contour.accompInQueue.push((Object) tmp);
      }

      // add in the next percussion event, if appropriate
      if ((percGroupEnum != null) &&
	  (percEnum.hasMoreElements()) &&
	  (percTime < Configuration.deltaTime))
      {
	update=true;
	tmp = (MusicElement) percGroupEnum.nextElement();
	percTime += tmp.duration;
	herman.form.Contour.percussionInQueue.push((Object) tmp);
      }
      
      // if nothing happened, then we just exit this loop
      if (!update)
	break;
    }      

    // start up the contour thingy (DO THIS HERE, so we're playing something
    // while processing the next phrase)
    herman.form.Contour.activate();


    // OK, check if we need to move onto the next Phrase
    if (((melodyEnum == null) || (!melodyEnum.hasMoreElements())) &&
	((accompEnum == null) || (!accompEnum.hasMoreElements())) &&
	((percEnum == null) || (!percEnum.hasMoreElements())) &&
	((melodyGroupEnum == null) || (!melodyGroupEnum.hasMoreElements())) &&
	((accompGroupEnum == null) || (!accompGroupEnum.hasMoreElements())) &&
	((percGroupEnum == null) || (!percGroupEnum.hasMoreElements())))
    {
      // ask for new Phrase to be sent
      if ((curPhrase = (Phrase) processedPhrases.next()) == null)
      {
	herman.form.PhraseForm.getNewPhrase();
	gettingNextPhrase = false;
      }
    }

     


    // we managed to get some data onwards, so return true
    return(true);
  }




  /**
   * Add a newly processed phrase onto the list of phrases
   *
   * @param p The phrase to add
   */
  protected static void addProcessedPhrase(Phrase p)
  {
    // if curPhrase is not currently set, bypass the queue entirely
    if (curPhrase == null)
    {
      curPhrase = p;
      melodyEnum = p.partMelEventGroup.getElements();
      accompEnum = p.partChord.getElements();
      percEnum = p.partPercEvent.getElements();
      return;
    }

    // otherwise, just add it in normally
    processedPhrases.add(p);
  }
}
