/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.rhythm;
import java.util.*;
import herman.elements.*;

public class Generate
{
  private Generate() {}


  public static void operate(Phrase newPhrase, RhythmStuff params)
    throws CloneNotSupportedException
  {
    melody(newPhrase, params);
    accomp(newPhrase, params);
    perc(newPhrase, params);
  }

  private static void melody(Phrase newPhrase,
			     RhythmStuff params)
    throws CloneNotSupportedException
  {
    // generate pattern of rhythmic feet for one motif
    Object[] retval = Foot.getPattern(params);
    Object[] motifEvents = (Object[]) retval[0];
    double realMotifLengthBeats = ((Double) retval[1]).doubleValue();

    newPhrase.duration = 0;
    
    // fill out rest of phrase with copies of this
    int startTimeMillis =0;
    int motifLengthMillis = params.motifLengthBeats * params.beatLengthMillis;
    int realMotifLengthMillis = 
      (int) (realMotifLengthBeats * params.beatLengthMillis);
    int phraseLengthMillis = params.phraseLengthBeats *params.beatLengthMillis;
    while(true)
    {
      // create a new EventGroup to hold this motif
      EventGroup curGroup = new EventGroup();
      Event curEvent = null;
      curGroup.startTime = startTimeMillis;
      System.out.println("Mel:Group:start=" + startTimeMillis);
      curGroup.duration = realMotifLengthMillis;
      newPhrase.partMelEventGroup.addElem(curGroup);

      // go through the motif, adding it's events into the Phrase
      for(int i=0; i< motifEvents.length; i++)
      {
	// make a copy of the Event
	curEvent = (Event) ((Event) motifEvents[i]).clone();
	curEvent.startTime += startTimeMillis;
	curGroup.partMelEvent.addElem(curEvent);
      }
     
      // update to the new motif starting time
      startTimeMillis += realMotifLengthMillis;      
      newPhrase.duration+=realMotifLengthMillis;

      // check we've not run out of time for this phrase
      if (startTimeMillis >= phraseLengthMillis)
	break;
    }
  }

  private static void accomp(Phrase newPhrase,
			     RhythmStuff params)
  {
    Enumeration eventGroups = newPhrase.partMelEventGroup.getElements();
    
    while(eventGroups.hasMoreElements())
    {
      EventGroup curGroup = (EventGroup) eventGroups.nextElement();
      Enumeration curEvents = curGroup.partMelEvent.getElements();
      Chord newChord = new Chord();
      newChord.startTime = curGroup.startTime;
      System.out.println("Chord:Group:start=" + curGroup.startTime);
      newChord.duration = curGroup.duration;
      newPhrase.partChord.addElem(newChord);

      while(curEvents.hasMoreElements())
	newChord.partAccompEvent.addElem((Event) ((Event) curEvents.nextElement()).clone());
    }
  }

  private static void perc(Phrase newPhrase,
			     RhythmStuff params)
  {}
}



