/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.properties;
import java.util.*;
import herman.form.transforms.PhraseTransform;

/** 
 * The TransformInfo class stores information relevant to the Transformer
 *    module.
 */

public class TransformInfo {
  
  // The storage is a StringBuffer.  
  private StringBuffer status = new StringBuffer();

  //transforms are stored as vectors
  private Vector transforms = new Vector();

  public TransformInfo() { /* Nothing */}
  

// Access Methods  

/**
 * Sets the first field
 */
  public void addTransform( PhraseTransform pt ) { 
    transforms.addElement(pt);
  }


/** 
 * Set the transformation status
 */
  public void setStatus( String l) {
    status.insert(0,l);
    status.setLength(l.length());
  }

/** 
 * Get the transformation status
 */
  public String getStatus() {
    return status.toString();
  }

/**
 * Gets the vector containing the transforms
 */
  public Vector getTransforms() {
    return transforms;
  }

/**
 * Gets the enumeration of the transforms
 */
  public Enumeration transformElements() {
    return transforms.elements();
  }

/**
 *  For debugging.
 */
  public static void main(String[] args) {
   
  }

/** 
 * Allows cloning
 
  public Object clone() {
    TransformInfo t = null;
    try {
      t = (TransformInfo)super.clone();
    } catch (CloneNotSupportedException e) {
      System.out.println("TransFormInfo can't clone");
    }
    System.out.println("TransFormInfo can't clone");
    t.info[0] = new StringBuffer(t.info[0].toString());
    t.info[1] = new StringBuffer(t.info[1].toString());
    return t;
  }
  */
}
