/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.properties;
/** 
 * The Timbre class represents timbre information as base register 
 * (an integer, with 0 corresponding to "Middle C") and some form of 
 * instrumentation, given as a string.
 **/

public class Timbre implements Cloneable {
  // The register is an int, with 0 corresponding to "Middle C"
  private int register = 0;          

  // The instrument is a StringBuffer, tanslated by the Player to a MIDI
  // instrument.
  private StringBuffer instrument = new StringBuffer("NONE");


/**
 * Return String describing timbre (for printing).
 */
  public String toString() {
    return "Timbre: " + getStrInstrument() + " in register " + 
      getRegister();
  }

  public Timbre() { /* Nothing */}
  
  
/**
 * Allocates a new Timbre object and assigns instrumentation and register.
 *@param r   the integer value of the register
 *@param instrStr    the String giving the instrumentation
 */
  public Timbre( int r, String instrStr ) {
    setInstrument(instrStr);
    setRegister(r);
    return;
  }


// Access Methods  

/**
 * Sets the instrumentation
 */
  public void setInstrument( String s ) { 
    instrument.insert(0,s);
    instrument.setLength(s.length());
  }

/**
 * Sets the register
 */
  public void setRegister( int r ) { register = r;}

/**
 * Gets the instrumentation as a String
 */
  public String getStrInstrument() { return instrument.toString();}
/**
 * Gets the register as an integer
 */
  public int getRegister() { return register;}


/**
 *  For debugging.
 */
  public static void main(String[] args) {
    Timbre p1 = new Timbre();
    System.out.println(p1.toString());
    p1.setRegister(3);
    p1.setInstrument("viola");
    System.out.println(p1.toString());
    p1.setRegister(2);
    System.out.println(p1.toString());
  }

/** 
 * Allows cloning
 */
  public Object clone() {
    Timbre t = null;  
    try {
      t = (Timbre)super.clone();
    } catch (CloneNotSupportedException e) {
      System.out.println("Timbre can't clone");
    }
    t.instrument = new StringBuffer(instrument.toString());
    return t;
  }
}




