/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.properties;

/** 
 *  The PitchTools class contains methods for manipulating Pitches and 
 *   Intervals
 */

public final class PitchTools {

  public static Pitch add(Pitch pitch, Interval interval) {
    Pitch newPitch = new Pitch((pitch.getRelPitch() 
                               + interval.getIntInterval()),
			       pitch.getRegister());
    return newPitch;
  }

  public static Interval subtract(Pitch first, Pitch second) {
    Interval result = new Interval(second.getAbsPitch() 
                               - first.getAbsPitch());
    return result;
  }

/** 
 * For debugging 
 */
  public static void main(String[] args) {
  
  }

}
