/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.properties;
/** 
 * The PitchInfo class carries information relevant to the Pitch Instantiator
 */

public class PitchInfo implements Cloneable {
  
  // The storage is a StringBuffer.  The first element gives location
  // information (or type information).  The second element expands this
  // information.

  private StringBuffer[] info = {new StringBuffer(), new StringBuffer()};


  public PitchInfo() { /* Nothing */}
  

// Access Methods  

/**
 * Sets the location
 */
  public void setLocation( String l ) { 
    info[0].insert(0,l);
    info[0].setLength(l.length());
  }

/**
 * Sets the second field
 */
  public void setSecond( String l ) { 
    info[1].insert(0,l);
    info[1].setLength(l.length());
  }

/**
 * Gets the location as a String
 */
  public String getLocation() { return info[0].toString();}

/**
 * Gets the second field as a String
 */
  public String getSecond() { return info[1].toString();}

/**
 *  For debugging.
 */
  public static void main(String[] args) {
    PitchInfo pi = new PitchInfo();
    pi.setLocation("bob");
    System.out.println(pi.getLocation());
   
  }

/** 
 * Allows cloning
 */
  public Object clone() {
    
    //  System.out.println(info[0].toString());
     PitchInfo p = new PitchInfo();
     /* try {
      p = (PitchInfo)super.clone();
    } catch (CloneNotSupportedException e) {
      System.out.println("PitchInfo can't clone");
    }
 */
    
   
    p.setLocation(info[0].toString());
    p.setSecond(info[1].toString());
    return p;
  }
}
