/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.properties;
import java.util.*;
import herman.elements.MusicElement;

/** This is the MusicElementList class.  Each MusicElementList object 
 * contains lists of music elements (one per type of music element).
 */

public class MusicElementList implements Cloneable {
  /**
   * Vec is the vector containing the music elements
   */
  private Vector vec = new Vector();

/** 
 *  Get the first MusicElement in the list
 */
  public MusicElement getFirst() { 
    if (vec.size() != 0) {
      return ((MusicElement)vec.firstElement());
    } else return null;
  }

/** 
 *  Get the MusicElement at the specified index in the list
 */
  public MusicElement getElemAt( int index) {
    if (vec.size() != 0) {
      return ((MusicElement)vec.elementAt(index));
    } else return null;
  }

/** 
 * Return the size of the list
 */
  public int size() { return vec.size(); }

/** 
 * Remove all the elements from the list
 */
  public void removeElems() { vec.removeAllElements(); return; }

/** 
 * Add an element to the end of the list
 */
  public void addElem( MusicElement musicEl ) {
    vec.addElement( musicEl ); return; }

/** 
 * Remove the element at the end of the list
 */
  public void removeLast() {
    vec.removeElementAt(vec.size() - 1);
  }

/** 
 * Get the element at the end of the list
 */
  public MusicElement getLast() {
    return (MusicElement)vec.elementAt(vec.size() - 1);
  }

  public Enumeration getElements()
  {
    return(vec.elements());
  }


  public void flush()
  {
    vec.removeAllElements();
  }

  //etc.
 
/** 
 * Allows cloning
 */
  public Object clone() {
    MusicElementList ml = null;
    try {
      ml = (MusicElementList)super.clone();
    } catch (CloneNotSupportedException e) {
      System.out.println("MusicElementList can't clone");
    }
    MusicElement[] me = new MusicElement[ml.vec.size()];
    Vector v = new Vector();
    
    for (int i = 0; i<ml.vec.size(); i++) {
      me[i] = ((MusicElement)((MusicElement)ml.getElemAt(i)).clone());
      v.addElement(me[i]);
    }
    
    ml.vec = v;
    return ml;
  }
}


