/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.properties;

/** 
 * The Inversion class indicates the inversion status of a chord.
 *
 **/

public class Inversion implements Cloneable {

  private int inversion = 0;

/**
 * Set the inversion using an integer
 */
  public void setInversion( int inv ) { inversion = inv;}

/**
 * Get the inversion as an integer
 */
  public int getInversion( ) { return inversion;}

/**
 * Allows cloning
 */
  public Object clone() {
    Object o = null;
    try {
      o = super.clone();
    } catch (CloneNotSupportedException e) {
      System.out.println("Inversion can't clone");
    }
    return o;
  }

}
