/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.properties;
/** 
 * The Interval class represents an interval by storing it as an integer value
 *  representing the number of semi-tones between two pitches.
 *
 * <p>
 * Intervals can be accessed either as integers or as their String
 * descriptions up to a M9.  The format of a String description is;
 *  [+,-] [M, m] [integer] (Ex. "+m7" = minor seventh up).
 **/

public class Interval /*extends MusicAttribute*/ {
  //The integer value.  -1000 is the default
  int interval = -1000; 


  // Convert +m7, etc. to integers
  private static int stringToInterval( String s ) {
    int i = 0;
    char[] intDes = new char[2];                  // The interval description
    char sign = s.charAt(0);                      // the directional sign
    intDes[0] = s.charAt(1);
    intDes[1] = s.charAt(2);
    String inter = new String(intDes);            //the String interval

    if (inter.equals("m2")) i = 1;
    else if (inter.equals("M2")) i = 2;
    else if (inter.equals("m3")) i = 3;
    else if (inter.equals("M3")) i = 4;
    else if (inter.equals("P4")) i = 5;
    else if (inter.equals("A4")) i = 6;
    else if (inter.equals("P5")) i = 7;
    else if (inter.equals("m6")) i = 8;
    else if (inter.equals("M6")) i = 9;
    else if (inter.equals("m7")) i = 10;
    else if (inter.equals("M7")) i = 11;
    else if (inter.equals("8v")) i = 12;
    else if (inter.equals("m9")) i = 13;
    else if (inter.equals("M9")) i = 14;
    else i = 0;


    if (sign == '-') {
      i = 0 - i;
    }
    return i;
  }
  
  // Convert integers for interval to Strings
  private static String intervalToString(int i ) {
    StringBuffer s = new StringBuffer(2);
    boolean upInterval = true;
    if ((i < 0)&&(i != -1000)) {
      i = 0 - i;
      upInterval = false;
    }

    if (i == 0) s.insert(0,"00");
    else if (i == 1) s.insert(0,"m2");
    else if (i == 2) s.insert(0,"M2");
    else if (i == 3) s.insert(0,"m3");
    else if (i == 4) s.insert(0,"M3");
    else if (i == 5) s.insert(0,"P4");
    else if (i == 6) s.insert(0,"A4");
    else if (i == 7) s.insert(0,"P5");
    else if (i == 8) s.insert(0,"m6");
    else if (i == 9) s.insert(0,"M6");
    else if (i == 10) s.insert(0,"m7");
    else if (i == 11) s.insert(0,"M7");
    else if (i == 12) s.insert(0,"8v");
    else if (i == 13) s.insert(0,"m9");
    else if (i == 14) s.insert(0,"M9");
    if ((upInterval)&&(i != -1000)) {
      s.insert(0,'+');
    }
    else s.insert(0,'-');

    String str = new String(s);
    str.trim();
    return str;
  }
  
/**
 * Return String describing absolute pitch (for printing).
 */
  public String toString() {
    return "Interval: " + intervalToString(interval);
  }

  public Interval() {/* Nothing */}

/**
* Allocates new Interval object and sets the  interval to the integer 
* value of the argument.
*/

  public Interval( int i ) {
    setInterval( i );
    return;
  }
  
/**
* Allocates new Interval object and sets the interval based on the  
* String description given in the argument..
*/
  public Interval( String i ) {
    setInterval( i );
    return;
  }


// Access methods

/**
 * Set the interval using an integer value.
 */
  public void setInterval( int i ) { interval = i;}

/**
 * Set the interval using a String description.
 */
  public void setInterval( String i ) { interval = stringToInterval(i);}


/**
 * Returns true if the interval has not been set yet.
 */
  public boolean isNull() { if (interval==-1000) 
    return true; else return false; }

/* ******************* NEED EXCEPTION HANDLING FOR NUL CASE!!! */
/**
 * Get the interval as an integer value.
 */
  public int getIntInterval() { return interval;}

/**
 * Get the interval as a String desrciption/
 */
  public String getStrInterval( ) { return intervalToString(interval);}




/**
 *  For debugging.
 */
  public static void main(String[] args) {
    Pitch p1 = new Pitch();
    System.out.println(p1.toString());
    System.out.println(p1.isNull());
    p1.setPitch(1);
    System.out.println(p1.toString());
    p1.setRegister(1);
    System.out.println(p1.toString());
  }

}
