/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.properties;
/** 
 * The Amplitude class represents the amplitude level as an integer between 
 * 0...127,  corresponding to MIDI amplitude representation.
 **/

public class Amplitude implements Cloneable {
  // The level is an integer
  private int level = -1000;          

/**
 * Return String describing amplitude (for printing).
 */
  public String toString() {
    return "Amplitude Level: " + getLevel();
  }

  public Amplitude() { /* Nothing */}
  
/**
 * Allocates a new Amplitude object and sets the amplitude level
 */
  public Amplitude(int a) {
    setLevel(a);  
    return;
  }

// Access Methods  

/**
 * Returns true if the level has not been set yet.
 */
  public boolean isNull() { if (level==-1000) 
    return true; else return false; }


/**
 * Sets the amplitude level
 */
  public void setLevel( int a ) { level = a; }
/**
 * Gets the amplitude level
 */
  public int getLevel() { return level;}


/**
 *  For debugging.
 */
  public static void main(String[] args) {
    Amplitude p1 = new Amplitude();
    System.out.println(p1.toString());
    System.out.println(p1.isNull());
    p1.setLevel(65);
    System.out.println(p1.toString());
    p1.setLevel(10);
    System.out.println(p1.toString());
  }

/**
 * Allows cloning
 */
  public Object clone() {
    Object o = null;
    try {
      o = super.clone();
    } catch (CloneNotSupportedException e) {
      System.out.println("Amplitude can't clone");
    }
    return o;
  }

}





