/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.player;
import herman.misc.*;
import herman.midiplayer.*;
import herman.midi.*;
import herman.elements.*;


/**
 * Converts music from CHARM into the events used by the MIDIPlayer module
 */
public class Player
{
  // starting time of this
  private static long startTime = 5000;
  
  // length of the current phrase
  private static long duration = 0;



  /**
   * This must be called whenever a new phrase is started.
   *
   * @param newDuration The duration of this phrase in milliseconds
   */
  public static void newPhrase(long newDuration)
  {
    System.out.println("New phrase: " + newDuration);
    // update phrase start times for previous phrase
    startTime += duration;
    duration = newDuration;
    

    if (herman.form.PhraseForm.currentPhrase.phraseInfo.getLocation().equals("sentence start")) 
    {
      startTime += 800;
      System.out.println("sentence starting...");
    }
  }


  /**
   * Sends a melody event to be played.
   *
   * @param e The event to play
   */
  public static void addMelody(Event e)
    throws MIDIDeviceBusyException
  {
    sendEvent(e, Configuration.MELODYCHANNEL);
  }


  /**
   * Sends an accompaniment event to be played.
   *
   * @param e The event to play
   */
  public static void addAccomp(Event e)
    throws MIDIDeviceBusyException
  {
    e.velocity -= 20;
    sendEvent(e, Configuration.ACCOMPCHANNEL);
  }


  /**
   * Sends a percussion event to be played.
   *
   * @param e The event to play
   */
  public static void addPerc(Event e)
    throws MIDIDeviceBusyException
  {
    sendEvent(e, Configuration.PERCCHANNEL);
  }
  

  

  /**
   * Private method to play an event
   *
   * @param e The event to play
   * @param channel The channel number to play it on
   */
  private static void sendEvent(Event e, int channel)
    throws MIDIDeviceBusyException
  {
    MidiPlayer.send(new MidiNoteOnEvent(channel, 
					e.pitch.getAbsPitch(),
					e.velocity,
					e.timbre.getStrInstrument(),
					startTime + e.startTime));

    MidiPlayer.send(new MidiNoteOffEvent(channel, 
					 e.pitch.getAbsPitch(),
					 e.velocity,
					 startTime +
					 e.startTime + e.duration));
  }

  /**
   * no instantiation
   */
  private Player(){}
}
