/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.tools;

/** 
 *  The ArrayTools class contains a set of static methods that manipulate
 *   arrays in various ways relevant to the Pitch Instantiator.
 */

public class ArrayTools {

/**
 * Set each member of array to the supplied value.
 */  
  public static void setArrayValue(float[] array, float value) {
    for (int i = 0; i < array.length; i++) {
      array[i] = value;
    }
  }

/**
 *  Set LEFT float array values equal to RIGHT float array values.
 *  NEEDS EXCEPTION HANDLING!!
 */
  public static void equalizeArrays(float[] lhs, float[] rhs) {
    for (int i = 0; i < lhs.length; i++) {
      lhs[i] = rhs[i];
    }
  }

/**
 * Multiply each member of the array by the supplied value
 */  
  public static void multiplyArrayBy(float[] array, float value) {
    for (int i = 0; i < array.length; i++) {
      array[i] = array[i]*value;
    }
  }

/**
 * Set each member of the LEFT array to the sum of that member plus the 
 * corresponding member of the RIGHT array.  NEEDS EXCEPTION HANDLING!!
 */  
  public static void add2Array(float[] lhs, float[] rhs) {
    for (int i = 0; i < lhs.length; i++) {
      lhs[i] = lhs[i]+rhs[i];
    }
  }

/**  
 * Normalize the supplied array, using positive values.
 */
  public static void normalizeArray(float[] array) {
    
    float arraySum = sumAbsArray(array);
    for (int i = 0; i < array.length; i++) {
      array[i] = array[i]/arraySum;
    }
  }

/**  
 * Set negative values to zero.
 */
  public static void clipNegative(float[] array) {
    for (int i = 0; i < array.length; i++) {
      if (array[i]<0.0f) {
	array[i] = 0.0f;
      }
    }
  }

/**  
 * Sum the absolute value of the members of the array.
 */
  public static float sumAbsArray(float[] array) {
    float sum = 0.0f;
    for (int i = 0; i < array.length; i++) {
      sum = sum + java.lang.Math.abs(array[i]);
    }
    return sum;
  }

/**  
 *Make a probabilistic selection of an index of the supplied probability
 *  array.
 */
  public static int probableSelect(float[] array) {
    clipNegative(array);
    normalizeArray(array);
  
    float rand = ((float)java.lang.Math.random());
    float sum = 0.0f;
    for (int i = 0; i < array.length; i++) {
      if (rand>(array[i]+sum)) {
	sum = sum + array[i];
      }
      else { return i;}
    }
    return (array.length-1);
  }

/**
 *  Print out the value of each memeber of the supplied array
 */
  public static void printArray(float[] array) {
    for (int i = 0; i < array.length; i++) {
      System.out.print(array[i]+"  "); 
    }
    System.out.println();
  }

/**
 *  Print out the value of each memeber of the supplied array.  Format to
 *   the specified # of columns per line.
 */
  public static void printArray(float[] array, int col) {
    for (int i = 0; i < array.length; i++) {
      System.out.print(array[i]+"  "); 
      if (((i+1) % col) == 0) System.out.println();
    }
    System.out.println();
  }

/** 
 * For debugging 
 */
  public static void main(String[] args) {
    float[] testArray = new float[5]; 
    float[] array = {4.0f, 4.0f, 4.0f, 54.0f, 4.0f};
    setArrayValue(testArray, 1.0f);
    printArray(testArray);
    multiplyArrayBy(testArray,6.0f);
    printArray(testArray);
    add2Array(testArray,array);
    printArray(testArray);
    normalizeArray(testArray);
    printArray(testArray);
  }

}
