/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.melody;
import herman.elements.*;
import herman.pitch.tools.*;
import herman.properties.*;
import herman.form.PhraseForm;

/** 
*   Applies rules governing the resolution of the melodic line at the 
*    end of a sentence.  At the moment, it only concerns situations when the
*    sentence ends on a "I" chord.
*/

public class Resolution {

  private static float Yes = 1.0f;
  private static float no = -1000.0f;

/** 
 * An integer in [0,3] indicating the finality of the resolution (0 is most
 *  final).
 */
  public static int finality = 1;

/** 
 * Returns a float[12] denoting the possible resolution tones (based on the
 *   finality setting).
 */
  public static float[] getResolveTones(Chord chord) {
    float[] resolve = new float[12];
    ArrayTools.setArrayValue(resolve, Yes);
    boolean minorFlag = false;

    if ((chord.chordType.getIntDegree()==1)&&
 (PhraseForm.currentPhrase.phraseInfo.getLocation().equals("sentence end"))) { 
      ArrayTools.setArrayValue(resolve, no);
      System.out.println("Melody resolving..." + finality);
      if (chord.key.getMode().equals("minor")) {
	minorFlag = true;
      }
     
      resolve[0] = Yes;            //The root is OK!
      if (finality == 1) {
	resolve[7] = Yes;           //The fifth is OK!
      }         
      else if ((finality == 2)&&(minorFlag)) {
	resolve[3] = Yes;           //the minor 3rd OK!
	resolve[7] = Yes;           //The fifth is OK!  
      }
      else if (finality == 2) {
	resolve[4] = Yes;           //the major 3rd OK!
	resolve[7] = Yes;           //The fifth is OK!  
      }
      else if (finality != 0) {
	ArrayTools.setArrayValue(resolve, Yes);     //no finality forced
      }
    }
    return resolve;
  }

}


