/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.melody;
import herman.pitch.tools.*;
import herman.elements.*;
import herman.pitch.instruments.*;

/** 
 * The MelodyRange class limits the melody to pitches within its range (as
 *  set in the Instrumentation class).
 **/

public class MelodyRange {

  //The "Not Possible Number"
  private static final float no = -1000.0f;
  private static final float Yes = 1.0f;

  public static float[] applyRangeLimits(Event lastMel) {
    int center = Instrumentation.getIntMelodyCenter();
    int[] range = Instrumentation.getMelodyRange();
    int relPitch = lastMel.pitch.getRelPitch();
    float[] intervals = new float[29];
    
    ArrayTools.setArrayValue(intervals,Yes);

    int lower = center - range[0];
    int upper = center + range[1];

    for (int i = 1; i<15; i++) {
      if ((relPitch - i) < lower) {
	intervals[14 - i] = no;
      }
      if ((relPitch + i) > upper) {
	intervals[14 + i] = no;
      }
    }

    return intervals;
  }

/**
 *  For debugging.
 */
  public static void main(String[] args) {
  
  }
}
