/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.melody;
import herman.properties.*;
import herman.pitch.tools.*;
import java.lang.Math;
/** 
 * The IntervalFollowing class contains rules that use the size of the
 *  previous interval to influence the selection of the new interval. 
 * <p>
 *  At the moment, it does noherman.
 **/

public class IntervalFollowing {

  //The "Not Possible Number"
  private static final float no = -1000.0f;
  private static final float Yes = 1.0f;

  //The following level
  private static float following = 0.0f;
  
  //The powerLevel
  private static float powerLevel = 1.0f;
 


  public IntervalFollowing() { /* Nothing */}
  
/**
 *  Applies the interval following rules.  Returns a float[] giving the 
 *   probabilities of each interval based on the interval following rules.
 *   <p>
 *  At the moment, this module doesn't actually do anyherman.
 */
  public static float[] applyFollowingRules(Interval lastInterval) {
    
    float[] positive = new float[15];
    float[] followIntervals = new float[29];

    for (int i = 0; i<15; i++) {
      positive[i] = 0.01f;
    }

    //Set the negative intervals
    for (int i = 0; i<14; i++) {
      followIntervals[i] = positive[14 - i];
    }
 
    //Set the positive (and zero) intervals:
    for (int i = 0; i<15; i++) {
      followIntervals[14 + i] = positive[i];
    }

    //Normalize & multiply by the powerLevel
    ArrayTools.normalizeArray(followIntervals);
    for (int i = 0; i<29; i++) {
      followIntervals[i] = followIntervals[i] * powerLevel;
    }
    
    return followIntervals;
  }

// Access Methods


/**
 *  Set the "following level".  
 * 
 */
  public static void setFollowing(float follow) {
    following = follow;
  }

/**
 *  Set the power level
 */
  public static void setPowerLevel(float power) {
    powerLevel = power;
  }

 
/**
 *  For debugging.
 */
  public static void main(String[] args) {
  
  }
}
