/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.melody;
import herman.pitch.tools.*;
import herman.elements.*;
import herman.pitch.harmony.PivotRules;

/** 
 * The ContourInstructions class reads and applies the contour instructions
 *  attached to each event.
 **/

public class ContourInstructions {

  //The "Not Possible Number"
  private static final float no = -1000.0f;
  private static final float Yes = 1.0f;

/**
 *  Applies the contour instructions assigned to the supplied melody event.
 *  Returns a float[] detailing the possible/impossible intervals.
 */
  public static float[] applyContour(Event mel) {
    float[] intervals = new float [29];
    ArrayTools.setArrayValue(intervals, Yes);
    if (mel.eventInfo.getSecond().length() > 0) {
      String contour = new String(mel.eventInfo.getSecond());
      
      if (contour.equals("up")) {
	for (int i = 0; i<15; i++) {     //eliminate down & same note poss.
	  intervals[i] = no;
	}
      }
      else if (contour.equals("down")) {  
	for (int i = 14; i<29; i++) {     //eliminate up &  same note poss.
	  intervals[i] = no;
	}
      }
      else if (contour.equals("same")) {  
	ArrayTools.setArrayValue(intervals, no);  //Set everything to zero,
	intervals[14] = Yes;                      //  except for same note
      }
    }
   
    return intervals;
  }

/**
 *  For debugging.
 */
  public static void main(String[] args) {
  
  }
}
