/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.io;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.*;
import herman.pitch.tools.ArrayTools;
import herman.pitch.harmony.*;
import herman.pitch.instruments.*;

/** 
 * The StartUp class contains the initialization methods for the Pitch 
 *  Instantiation module.
 */
 
public class PitchStartUp {
 
/** 
 * Intializes the Pitch Instantiator module
 */
  public static void initialize() {
    KeyControl.setCurrentKeyType(0);
    KeyControl.setCurrentMode("major");
    DissonanceLevel.setDissonanceLevel(10.0f);
    DissonanceHandling.setDissonancePrep(2);
    DissonanceHandling.setDissonanceRes(2);
    ChordInstantiator.initialize();

    IntervalPreference.initialize();
    IntervalHarshness.initialize();
    FixedPitchSettings.apply(0);
  }
}
