/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.io;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.*;
import herman.pitch.tools.ArrayTools;
import herman.player.Player;
import herman.misc.FatalError;

/** 
 * The PitchInstOutput class contains the methods that send music elements
 *  out of the Pitch module and on to the Player
 */
 
public class PitchInstOutput {

/**
 *  Sends the supplied melody event on to the Player
 */
  public static void sendOutMelody(Event event) {
    //System.out.println("Melody: " + event);
   
    //wheres the PLayer??
    try
    {
      Player.addMelody(event);
    }
    catch (Exception e)
    {
      e.printStackTrace();
      throw new FatalError(e.toString());
    }
  }

/**
 *  Sends the supplied accompaniment event on to the Player
 */
  public static void sendOutAccompaniment(Event event) {

    //wheres the PLayer??
    //System.out.println("Acmp: "+event);

    try
    {
      Player.addAccomp(event);
    }
    catch (Exception e)
    {
      e.printStackTrace();
      throw new FatalError(e.toString());
    }
  }

/**
 *  Sends the supplied percussion event on to the Player
 */  
  public static void sendOutPercussion(Event event) {

    //wheres the PLayer??
    try
    {
      Player.addPerc(event);
    }
    catch (Exception e)
    {
      e.printStackTrace();
      throw new FatalError(e.toString());
    }
    
  }
}
